/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubException;
import com.microsoft.azure.sdk.iot.service.exceptions.IotHubExceptionManager;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AuthenticationMessageCallback;
import com.microsoft.azure.sdk.iot.service.transport.amqps.CbsReceiverLinkHandler;
import com.microsoft.azure.sdk.iot.service.transport.amqps.CbsSenderLinkHandler;
import com.microsoft.azure.sdk.iot.service.transport.amqps.CbsSessionStateCallback;
import com.microsoft.azure.sdk.iot.service.transport.amqps.ErrorLoggingBaseHandlerWithCleanup;
import com.microsoft.azure.sdk.iot.service.transport.amqps.LinkStateCallback;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.UUID;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CbsSessionHandler
extends ErrorLoggingBaseHandlerWithCleanup
implements AuthenticationMessageCallback,
LinkStateCallback {
    private static final Logger log = LoggerFactory.getLogger(CbsSessionHandler.class);
    private static final double TOKEN_RENEWAL_PERCENT = 0.85;
    private Session session;
    private CbsSenderLinkHandler cbsSenderLinkHandler;
    private CbsReceiverLinkHandler cbsReceiverLinkHandler;
    private final CbsSessionStateCallback cbsSessionStateCallback;
    private TokenCredential credential;
    private String connectionString;
    private AzureSasCredential sasTokenProvider;
    private boolean senderLinkOpened = false;
    private boolean receiverLinkOpened = false;

    CbsSessionHandler(Session session, CbsSessionStateCallback cbsSessionStateCallback, TokenCredential credential) {
        this(session, cbsSessionStateCallback);
        this.credential = credential;
    }

    CbsSessionHandler(Session session, CbsSessionStateCallback cbsSessionStateCallback, AzureSasCredential sasTokenProvider) {
        this(session, cbsSessionStateCallback);
        this.sasTokenProvider = sasTokenProvider;
    }

    CbsSessionHandler(Session session, CbsSessionStateCallback cbsSessionStateCallback, String connectionString) {
        this(session, cbsSessionStateCallback);
        this.connectionString = connectionString;
    }

    private CbsSessionHandler(Session session, CbsSessionStateCallback cbsSessionStateCallback) {
        BaseHandler.setHandler((Extendable)session, (Handler)this);
        this.session = session;
        this.cbsSessionStateCallback = cbsSessionStateCallback;
        this.session.open();
    }

    @Override
    public void onSessionLocalOpen(Event event) {
        this.session = event.getSession();
        Sender cbsSender = this.session.sender(CbsSenderLinkHandler.getCbsTag());
        this.cbsSenderLinkHandler = this.credential != null ? new CbsSenderLinkHandler(cbsSender, (LinkStateCallback)this, this.credential) : (this.sasTokenProvider != null ? new CbsSenderLinkHandler(cbsSender, (LinkStateCallback)this, this.sasTokenProvider) : new CbsSenderLinkHandler(cbsSender, (LinkStateCallback)this, this.connectionString));
        Receiver cbsReceiver = this.session.receiver(CbsReceiverLinkHandler.getCbsTag());
        this.cbsReceiverLinkHandler = new CbsReceiverLinkHandler(cbsReceiver, this, (LinkStateCallback)this);
    }

    @Override
    public void onSessionRemoteOpen(Event e) {
        log.trace("CBS session opened remotely");
    }

    @Override
    public void onSessionLocalClose(Event e) {
        log.trace("CBS session closed locally");
        this.session.getConnection().close();
        this.cbsSenderLinkHandler.close();
        this.cbsReceiverLinkHandler.close();
    }

    @Override
    public void onSessionRemoteClose(Event e) {
        Session session = e.getSession();
        if (session.getLocalState() == EndpointState.ACTIVE) {
            this.close();
        }
    }

    void close() {
        log.trace("Closing this CBS session");
        this.session.close();
        this.cbsSenderLinkHandler.close();
        this.cbsReceiverLinkHandler.close();
    }

    @Override
    public DeliveryState handleAuthenticationResponseMessage(int status, String description) {
        if (status == 200) {
            log.debug("CBS session successfully authenticated");
            this.cbsSessionStateCallback.onAuthenticationSucceeded();
        } else {
            IotHubException e = IotHubExceptionManager.mapException(status, description);
            log.error("CBS session failed to authenticate", (Throwable)e);
            this.cbsSessionStateCallback.onAuthenticationFailed(e);
            this.session.close();
        }
        return Accepted.getInstance();
    }

    @Override
    public void onSenderLinkRemoteOpen() {
        this.senderLinkOpened = true;
        if (this.receiverLinkOpened) {
            this.authenticate();
        }
    }

    @Override
    public void onReceiverLinkRemoteOpen() {
        this.receiverLinkOpened = true;
        if (this.senderLinkOpened) {
            this.authenticate();
        }
    }

    public void onTimerTask(Event event) {
        log.debug("Proactively renewing AMQPS connection by sending a new authentication message");
        this.authenticate();
    }

    boolean isOpen() {
        return this.session != null && this.session.getLocalState() == EndpointState.ACTIVE && this.session.getRemoteState() == EndpointState.ACTIVE && this.cbsSenderLinkHandler != null && this.cbsSenderLinkHandler.isOpen();
    }

    private void authenticate() {
        UUID authenticationMessageCorrelationId = UUID.randomUUID();
        this.cbsReceiverLinkHandler.setAuthenticationMessageCorrelationId(authenticationMessageCorrelationId);
        int authenticationMessageDeliveryTag = this.cbsSenderLinkHandler.sendAuthenticationMessage(authenticationMessageCorrelationId);
        AccessToken currentAccessToken = this.cbsSenderLinkHandler.getCurrentAccessToken();
        if (authenticationMessageDeliveryTag == -1) {
            log.error("Failed to send authentication message");
        } else {
            log.debug("Successfully sent authentication message");
        }
        if (this.credential != null || this.sasTokenProvider != null) {
            OffsetDateTime currentOffsetDateTime = OffsetDateTime.now();
            OffsetDateTime tokenExpiryOffsetDateTime = currentAccessToken.getExpiresAt();
            Duration diff = Duration.between(tokenExpiryOffsetDateTime, currentOffsetDateTime).abs();
            long millisecondsToTokenExpiry = diff.toMillis();
            double proactiveTokenRenewalMillis = (double)millisecondsToTokenExpiry * 0.85;
            if (proactiveTokenRenewalMillis >= 2.147483647E9) {
                this.scheduleProactiveRenewal(Integer.MAX_VALUE);
            } else {
                this.scheduleProactiveRenewal((int)proactiveTokenRenewalMillis);
            }
        }
    }

    private void scheduleProactiveRenewal(int millisecondsBeforeRenewal) {
        log.debug("Scheduling proactive token renewal for {} milliseconds in the future", (Object)millisecondsBeforeRenewal);
        this.session.getConnection().getReactor().schedule(millisecondsBeforeRenewal, (Handler)this);
    }
}

