/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.microsoft.azure.sdk.iot.service.messaging.Message;
import com.microsoft.azure.sdk.iot.service.messaging.SendResult;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;

class CloudToDeviceMessage {
    private static final String DEVICE_PATH_FORMAT = "/devices/%s/messages/devicebound";
    private static final String MODULE_PATH_FORMAT = "/devices/%s/modules/%s/messages/devicebound";
    final Message iotHubMessage;
    final String targetDeviceId;
    final String targetModuleId;
    final Consumer<SendResult> onMessageSentCallback;
    final Object onMessageSentCallbackContext;
    final org.apache.qpid.proton.message.Message protonMessage;

    CloudToDeviceMessage(String targetDeviceId, String targetModuleId, Message iotHubMessage, Consumer<SendResult> onMessageSentCallback, Object onMessageSentCallbackContext) {
        this.targetDeviceId = targetDeviceId;
        this.targetModuleId = targetModuleId;
        this.iotHubMessage = iotHubMessage;
        this.onMessageSentCallback = onMessageSentCallback;
        this.onMessageSentCallbackContext = onMessageSentCallbackContext;
        this.protonMessage = this.targetModuleId != null ? CloudToDeviceMessage.createProtonMessage(this.targetDeviceId, this.targetModuleId, this.iotHubMessage) : CloudToDeviceMessage.createProtonMessage(this.targetDeviceId, this.iotHubMessage);
    }

    String getCorrelationId() {
        return this.getIotHubMessage().getCorrelationId();
    }

    private static org.apache.qpid.proton.message.Message createProtonMessage(String deviceId, Message message) {
        return CloudToDeviceMessage.populateProtonMessage(String.format(DEVICE_PATH_FORMAT, deviceId), message);
    }

    private static org.apache.qpid.proton.message.Message createProtonMessage(String deviceId, String moduleId, Message message) {
        return CloudToDeviceMessage.populateProtonMessage(String.format(MODULE_PATH_FORMAT, deviceId, moduleId), message);
    }

    private static org.apache.qpid.proton.message.Message populateProtonMessage(String targetPath, Message message) {
        org.apache.qpid.proton.message.Message protonMessage = Proton.message();
        Properties properties = new Properties();
        properties.setMessageId((Object)message.getMessageId());
        properties.setTo(targetPath);
        properties.setAbsoluteExpiryTime(message.getExpiryTimeUtc());
        properties.setCorrelationId((Object)message.getCorrelationId());
        if (message.getUserId() != null) {
            properties.setUserId(new Binary(message.getUserId().getBytes(StandardCharsets.UTF_8)));
        }
        protonMessage.setProperties(properties);
        if (message.getProperties() != null && message.getProperties().size() > 0) {
            HashMap<String, String> applicationPropertiesMap = new HashMap<String, String>(message.getProperties().size());
            applicationPropertiesMap.putAll(message.getProperties());
            ApplicationProperties applicationProperties = new ApplicationProperties(applicationPropertiesMap);
            protonMessage.setApplicationProperties(applicationProperties);
        }
        Binary binary = message.getBytes() != null ? new Binary(message.getBytes()) : new Binary(new byte[0]);
        Data section = new Data(binary);
        protonMessage.setBody((Section)section);
        return protonMessage;
    }

    public Message getIotHubMessage() {
        return this.iotHubMessage;
    }

    public String getTargetDeviceId() {
        return this.targetDeviceId;
    }

    public String getTargetModuleId() {
        return this.targetModuleId;
    }

    public Consumer<SendResult> getOnMessageSentCallback() {
        return this.onMessageSentCallback;
    }

    public Object getOnMessageSentCallbackContext() {
        return this.onMessageSentCallbackContext;
    }

    public org.apache.qpid.proton.message.Message getProtonMessage() {
        return this.protonMessage;
    }
}

