/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.microsoft.azure.sdk.iot.service.ProxyOptions;
import com.microsoft.azure.sdk.iot.service.messaging.ErrorContext;
import com.microsoft.azure.sdk.iot.service.messaging.IotHubServiceClientProtocol;
import com.microsoft.azure.sdk.iot.service.messaging.Message;
import com.microsoft.azure.sdk.iot.service.messaging.SendResult;
import com.microsoft.azure.sdk.iot.service.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpConnectionHandler;
import com.microsoft.azure.sdk.iot.service.transport.amqps.CloudToDeviceMessageSenderLinkHandler;
import com.microsoft.azure.sdk.iot.service.transport.amqps.LinkStateCallback;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudToDeviceMessageConnectionHandler
extends AmqpConnectionHandler
implements LinkStateCallback {
    private static final Logger log = LoggerFactory.getLogger(CloudToDeviceMessageConnectionHandler.class);
    private static final String SEND_TAG = "sender";
    private static final String ENDPOINT = "/messages/devicebound";
    private Session session;
    private CloudToDeviceMessageSenderLinkHandler cloudToDeviceMessageSenderLinkHandler;
    private Runnable onConnectionOpenedCallback;

    public CloudToDeviceMessageConnectionHandler(String connectionString, IotHubServiceClientProtocol protocol, Consumer<ErrorContext> errorProcessor, ProxyOptions proxyOptions, SSLContext sslContext, int keepAliveIntervalSeconds) {
        super(connectionString, protocol, errorProcessor, proxyOptions, sslContext, keepAliveIntervalSeconds);
    }

    public CloudToDeviceMessageConnectionHandler(String hostName, TokenCredential credential, IotHubServiceClientProtocol protocol, Consumer<ErrorContext> errorProcessor, ProxyOptions proxyOptions, SSLContext sslContext, int keepAliveIntervalSeconds) {
        super(hostName, credential, protocol, errorProcessor, proxyOptions, sslContext, keepAliveIntervalSeconds);
    }

    public CloudToDeviceMessageConnectionHandler(String hostName, AzureSasCredential azureSasCredential, IotHubServiceClientProtocol protocol, Consumer<ErrorContext> errorProcessor, ProxyOptions proxyOptions, SSLContext sslContext, int keepAliveIntervalSeconds) {
        super(hostName, azureSasCredential, protocol, errorProcessor, proxyOptions, sslContext, keepAliveIntervalSeconds);
    }

    @Override
    public void onAuthenticationSucceeded() {
        if (this.cloudToDeviceMessageSenderLinkHandler == null) {
            this.session = this.connection.session();
            HashMap<Symbol, String> properties = new HashMap<Symbol, String>();
            properties.put(Symbol.getSymbol((String)"com.microsoft:client-version"), TransportUtils.USER_AGENT_STRING);
            this.session.open();
            Sender cloudToDeviceMessageSendingLink = this.session.sender(SEND_TAG);
            cloudToDeviceMessageSendingLink.setProperties(properties);
            Target t = new Target();
            t.setAddress(ENDPOINT);
            cloudToDeviceMessageSendingLink.setTarget((org.apache.qpid.proton.amqp.transport.Target)t);
            cloudToDeviceMessageSendingLink.open();
            this.cloudToDeviceMessageSenderLinkHandler = new CloudToDeviceMessageSenderLinkHandler(cloudToDeviceMessageSendingLink, UUID.randomUUID().toString(), this);
            log.debug("Opening sender link for amqp cloud to device messages");
        }
    }

    @Override
    public void onSenderLinkRemoteOpen() {
        this.onConnectionOpenedCallback.run();
    }

    @Override
    public void onReceiverLinkRemoteOpen() {
    }

    @Override
    public boolean isOpen() {
        return super.isOpen() && this.session != null && this.session.getLocalState() == EndpointState.ACTIVE && this.session.getRemoteState() == EndpointState.ACTIVE && this.cloudToDeviceMessageSenderLinkHandler != null && this.cloudToDeviceMessageSenderLinkHandler.isOpen();
    }

    public void sendAsync(String deviceId, String moduleId, Message iotHubMessage, Consumer<SendResult> callback, Object context) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Client is currently closed. Must open messagingClient before sending.");
        }
        this.cloudToDeviceMessageSenderLinkHandler.sendAsync(deviceId, moduleId, iotHubMessage, callback, context);
    }

    @Override
    public void closeAsync(Runnable onConnectionClosedCallback) {
        if (this.cloudToDeviceMessageSenderLinkHandler != null) {
            log.debug("Shutdown event occurred, closing file upload notification receiver link");
            this.cloudToDeviceMessageSenderLinkHandler.close();
        }
        if (this.session != null) {
            log.debug("Shutdown event occurred, closing session");
            this.session.close();
        }
        super.closeAsync(onConnectionClosedCallback);
    }

    public void onReactorFinal(Event event) {
        this.cloudToDeviceMessageSenderLinkHandler = null;
    }

    public void setOnConnectionOpenedCallback(Runnable onConnectionOpenedCallback) {
        this.onConnectionOpenedCallback = onConnectionOpenedCallback;
    }
}

