/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.microsoft.azure.sdk.iot.service.messaging.AcknowledgementType;
import com.microsoft.azure.sdk.iot.service.messaging.FeedbackBatch;
import com.microsoft.azure.sdk.iot.service.messaging.FeedbackBatchMessage;
import com.microsoft.azure.sdk.iot.service.transport.amqps.LinkStateCallback;
import com.microsoft.azure.sdk.iot.service.transport.amqps.ReceiverLinkHandler;
import java.util.UUID;
import java.util.function.Function;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFeedbackReceiverLinkHandler
extends ReceiverLinkHandler {
    private static final Logger log = LoggerFactory.getLogger(MessageFeedbackReceiverLinkHandler.class);
    private final Function<FeedbackBatch, AcknowledgementType> feedbackBatchReceivedCallback;

    public MessageFeedbackReceiverLinkHandler(Receiver link, LinkStateCallback linkStateCallback, Function<FeedbackBatch, AcknowledgementType> feedbackBatchReceivedCallback) {
        super(link, UUID.randomUUID().toString(), linkStateCallback);
        this.feedbackBatchReceivedCallback = feedbackBatchReceivedCallback;
    }

    public void onDelivery(Event event) {
        Receiver recv = (Receiver)event.getLink();
        Delivery delivery = recv.current();
        if (delivery.isReadable() && !delivery.isPartial()) {
            int size = delivery.pending();
            byte[] buffer = new byte[size];
            int read = recv.recv(buffer, 0, buffer.length);
            recv.advance();
            Message msg = Proton.message();
            msg.decode(buffer, 0, read);
            if (msg.getBody() instanceof Data) {
                AcknowledgementType messageResult = AcknowledgementType.ABANDON;
                try {
                    String feedbackJson = ((Data)msg.getBody()).getValue().toString();
                    FeedbackBatch feedbackBatch = FeedbackBatchMessage.parse(feedbackJson);
                    messageResult = this.feedbackBatchReceivedCallback.apply(feedbackBatch);
                }
                catch (Exception e) {
                    log.warn("Encountered an exception while handling feedback batch message", (Throwable)e);
                }
                Accepted deliveryState = Accepted.getInstance();
                if (messageResult == AcknowledgementType.ABANDON) {
                    deliveryState = Released.getInstance();
                } else if (messageResult == AcknowledgementType.COMPLETE) {
                    deliveryState = Accepted.getInstance();
                }
                delivery.disposition((DeliveryState)deliveryState);
                delivery.settle();
                recv.flow(1);
            }
        }
    }

    @Override
    String getLinkInstanceType() {
        return "messageFeedbackReceiver";
    }
}

