/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.transport.amqps;

import com.microsoft.azure.sdk.iot.service.transport.amqps.AmqpsMessage;
import com.microsoft.azure.sdk.iot.service.transport.amqps.LinkStateCallback;
import com.microsoft.azure.sdk.iot.service.transport.amqps.LoggingFlowController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ReceiverLinkHandler
extends BaseHandler {
    private static final Logger log = LoggerFactory.getLogger(ReceiverLinkHandler.class);
    private static final String API_VERSION_KEY = "com.microsoft:api-version";
    private final Map<Symbol, Object> amqpProperties = new HashMap<Symbol, Object>();
    String receiverLinkTag;
    private final String linkCorrelationId;
    String receiverLinkAddress;
    private final Receiver receiverLink;
    private final LinkStateCallback linkStateCallback;

    abstract String getLinkInstanceType();

    ReceiverLinkHandler(Receiver receiver, String linkCorrelationId, LinkStateCallback linkStateCallback) {
        this.amqpProperties.put(Symbol.getSymbol((String)API_VERSION_KEY), "2021-04-12");
        this.receiverLink = receiver;
        this.linkCorrelationId = linkCorrelationId;
        this.linkStateCallback = linkStateCallback;
        BaseHandler.setHandler((Extendable)receiver, (Handler)this);
        this.add((Handler)new LoggingFlowController(this.linkCorrelationId));
    }

    public void onLinkRemoteOpen(Event event) {
        log.debug("{} receiver link with link correlation id {} was successfully opened", (Object)this.getLinkInstanceType(), (Object)this.linkCorrelationId);
        this.linkStateCallback.onReceiverLinkRemoteOpen();
        boolean hasFlowController = false;
        Iterator children = this.children();
        while (children.hasNext()) {
            hasFlowController |= children.next() instanceof LoggingFlowController;
        }
        if (!hasFlowController) {
            log.trace("No flow controller detected in {} link with address {} and link correlation id {}. Adding a new flow controller.", new Object[]{this.getLinkInstanceType(), this.receiverLinkAddress, this.linkCorrelationId});
            this.add((Handler)new LoggingFlowController(this.linkCorrelationId));
        }
    }

    public void onLinkLocalOpen(Event event) {
        log.trace("{} receiver link with link correlation id {} opened locally", (Object)this.getLinkInstanceType(), (Object)this.linkCorrelationId);
    }

    AmqpsMessage getMessageFromReceiverLink() {
        Delivery delivery = this.receiverLink.current();
        if (delivery.isReadable() && !delivery.isPartial()) {
            int size = delivery.pending();
            byte[] buffer = new byte[size];
            int read = this.receiverLink.recv(buffer, 0, buffer.length);
            this.receiverLink.advance();
            AmqpsMessage message = new AmqpsMessage();
            message.decode(buffer, 0, read);
            message.setDelivery(delivery);
            return message;
        }
        return null;
    }

    public void onLinkInit(Event event) {
        Link link = event.getLink();
        Source source = new Source();
        source.setAddress(this.receiverLinkAddress);
        link.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        link.setProperties(this.amqpProperties);
        link.open();
        log.trace("Opening {} receiver link with correlation id {}", (Object)this.getLinkInstanceType(), (Object)this.linkCorrelationId);
    }

    public void onLinkRemoteClose(Event event) {
        Link link = event.getLink();
        if (link.getLocalState() == EndpointState.ACTIVE) {
            log.debug("{} receiver link with link correlation id {} was closed remotely unexpectedly", (Object)this.getLinkInstanceType(), (Object)this.linkCorrelationId);
            link.close();
        } else {
            log.trace("Closing amqp session now that this {} receiver link with link correlation id {} has closed remotely and locally", (Object)this.getLinkInstanceType(), (Object)this.linkCorrelationId);
            event.getSession().close();
        }
    }

    public void onLinkLocalClose(Event event) {
        Link link = event.getLink();
        if (link.getRemoteState() == EndpointState.CLOSED) {
            log.trace("Closing amqp session now that this {} receiver link with link correlation id {} has closed remotely and locally", (Object)this.getLinkInstanceType(), (Object)this.linkCorrelationId);
            event.getSession().close();
        } else {
            log.trace("{} receiver link with correlation id {} was closed locally", (Object)this.getLinkInstanceType(), (Object)this.linkCorrelationId);
        }
    }

    void close() {
        if (this.receiverLink.getLocalState() != EndpointState.CLOSED) {
            log.debug("Closing {} receiver link with link correlation id {}", (Object)this.getLinkInstanceType(), (Object)this.linkCorrelationId);
            this.receiverLink.close();
        }
    }
}

