/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.twin;

import com.microsoft.azure.sdk.iot.service.twin.ConfigurationInfo;
import com.microsoft.azure.sdk.iot.service.twin.DeviceCapabilities;
import com.microsoft.azure.sdk.iot.service.twin.TwinCollection;
import com.microsoft.azure.sdk.iot.service.twin.TwinState;
import com.microsoft.azure.sdk.iot.service.twin.TwinStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Twin {
    private String deviceId;
    private String moduleId;
    private String eTag;
    private TwinStatus status;
    private String statusUpdateTime;
    private String lastActivityTime;
    private Integer cloudToDeviceMessageCount;
    private Integer version;
    private final TwinCollection tags = new TwinCollection();
    private final TwinCollection reportedProperties = new TwinCollection();
    private final TwinCollection desiredProperties = new TwinCollection();
    private Map<String, ConfigurationInfo> configurations;
    private DeviceCapabilities capabilities;
    private String connectionState;
    private String modelId;
    private String deviceScope;
    private List<String> parentScopes = new ArrayList<String>();

    public static Twin fromJson(String json) {
        TwinState twinState = new TwinState(json);
        Twin twin = new Twin(twinState.getDeviceId());
        twin.setVersion(twinState.getVersion());
        twin.setETag(twinState.getETag());
        twin.setStatus(twinState.getStatus());
        twin.setStatusUpdateTime(twinState.getStatusUpdatedTime());
        twin.setConnectionState(twinState.getConnectionState());
        twin.setLastActivityTime(twinState.getLastActivityTime());
        twin.setCloudToDeviceMessageCount(twinState.getCloudToDeviceMessageCount());
        twin.getTags().setVersion(twinState.getTags().getVersion());
        if (twinState.getTags().size() > 0) {
            twin.getTags().putAll(twinState.getTags());
        }
        if (twinState.getDesiredProperties() != null) {
            twin.getDesiredProperties().setVersion(twinState.getDesiredProperties().getVersion());
            if (twinState.getDesiredProperties().size() > 0) {
                twin.getDesiredProperties().putAll(twinState.getDesiredProperties());
            }
            twin.getDesiredProperties().setTwinMetadata(twinState.getDesiredProperties().getTwinMetadata());
            if (twinState.getDesiredProperties().getMetadataMap().size() > 0) {
                twin.getDesiredProperties().getMetadataMap().putAll(twinState.getDesiredProperties().getMetadataMap());
            }
        }
        if (twinState.getReportedProperties() != null) {
            twin.getReportedProperties().setVersion(twinState.getReportedProperties().getVersion());
            if (twinState.getReportedProperties().size() > 0) {
                twin.getReportedProperties().putAll(twinState.getReportedProperties());
            }
            twin.getReportedProperties().setTwinMetadata(twinState.getReportedProperties().getTwinMetadata());
            if (twinState.getReportedProperties().getMetadataMap().size() > 0) {
                twin.getReportedProperties().getMetadataMap().putAll(twinState.getReportedProperties().getMetadataMap());
            }
        }
        twin.setCapabilities(twinState.getCapabilities());
        twin.setConnectionState(twinState.getConnectionState());
        twin.setConfigurations(twinState.getConfigurations());
        twin.setModelId(twinState.getModelId());
        twin.setDeviceScope(twinState.getDeviceScope());
        twin.setParentScopes(twinState.getParentScopes());
        if (twinState.getModuleId() != null && !twinState.getModuleId().isEmpty()) {
            twin.setModuleId(twinState.getModuleId());
        }
        return twin;
    }

    public Twin() {
    }

    public Twin(String deviceId) throws IllegalArgumentException {
        this();
        this.deviceId = deviceId;
    }

    public Twin(String deviceId, String moduleId) throws IllegalArgumentException {
        this();
        this.deviceId = deviceId;
        this.moduleId = moduleId;
    }

    public TwinCollection getTags() {
        return this.tags;
    }

    public TwinCollection getDesiredProperties() {
        return this.desiredProperties;
    }

    public TwinCollection getReportedProperties() {
        return this.reportedProperties;
    }

    void setDeviceScope(String deviceScope) {
        this.deviceScope = deviceScope;
    }

    void setParentScopes(List<String> parentScopes) {
        this.parentScopes = parentScopes;
    }

    public String toString() {
        StringBuilder thisDevice = new StringBuilder();
        thisDevice.append("Device Id: ").append(this.deviceId).append("\n");
        if (this.moduleId != null && !this.moduleId.isEmpty()) {
            thisDevice.append("Module Id: ").append(this.moduleId).append("\n");
        }
        if (this.eTag != null) {
            thisDevice.append("ETag: ").append(this.eTag).append("\n");
        }
        if (this.version != null) {
            thisDevice.append("Version: ").append(this.version).append("\n");
        }
        thisDevice.append("Model Id: ").append(this.modelId).append("\n");
        if (this.deviceScope != null) {
            thisDevice.append("Device scope: ").append(this.deviceScope).append("\n");
        }
        if (this.parentScopes != null && !this.parentScopes.isEmpty()) {
            thisDevice.append("Parent scopes: ").append(String.join((CharSequence)",", this.parentScopes)).append("\n");
        }
        if (this.status != null) {
            thisDevice.append("Status: ").append(this.status.toString()).append("\n");
        }
        if (this.statusUpdateTime != null) {
            thisDevice.append("StatusUpdateTime: ").append(this.statusUpdateTime).append("\n");
        }
        if (this.connectionState != null) {
            thisDevice.append("ConnectionState: ").append(this.connectionState).append("\n");
        }
        if (this.lastActivityTime != null) {
            thisDevice.append("LastActivityTime: ").append(this.lastActivityTime).append("\n");
        }
        if (this.cloudToDeviceMessageCount != null) {
            thisDevice.append("CloudToDeviceMessageCount:").append(this.cloudToDeviceMessageCount.toString()).append("\n");
        }
        thisDevice.append(this.tagsToString());
        thisDevice.append(this.reportedPropertiesToString());
        thisDevice.append(this.desiredPropertiesToString());
        return thisDevice.toString();
    }

    private String tagsToString() {
        return "Tags: " + this.tags.toString() + "\n";
    }

    private String desiredPropertiesToString() {
        return "Desired properties: " + this.desiredProperties.toString() + "\n";
    }

    private String reportedPropertiesToString() {
        return "Reported properties: " + this.reportedProperties.toString() + "\n";
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public TwinStatus getStatus() {
        return this.status;
    }

    public void setStatus(TwinStatus status) {
        this.status = status;
    }

    public String getStatusUpdateTime() {
        return this.statusUpdateTime;
    }

    public void setStatusUpdateTime(String statusUpdateTime) {
        this.statusUpdateTime = statusUpdateTime;
    }

    public String getLastActivityTime() {
        return this.lastActivityTime;
    }

    public void setLastActivityTime(String lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
    }

    public Integer getCloudToDeviceMessageCount() {
        return this.cloudToDeviceMessageCount;
    }

    public void setCloudToDeviceMessageCount(Integer cloudToDeviceMessageCount) {
        this.cloudToDeviceMessageCount = cloudToDeviceMessageCount;
    }

    public Integer getVersion() {
        return this.version;
    }

    void setVersion(Integer version) {
        this.version = version;
    }

    public Map<String, ConfigurationInfo> getConfigurations() {
        return this.configurations;
    }

    void setConfigurations(Map<String, ConfigurationInfo> configurations) {
        this.configurations = configurations;
    }

    public DeviceCapabilities getCapabilities() {
        return this.capabilities;
    }

    void setCapabilities(DeviceCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    void setConnectionState(String connectionState) {
        this.connectionState = connectionState;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getDeviceScope() {
        return this.deviceScope;
    }

    public List<String> getParentScopes() {
        return this.parentScopes;
    }
}

