/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.twin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.azure.sdk.iot.service.ParserUtility;
import com.microsoft.azure.sdk.iot.service.twin.Tools;
import java.util.Date;
import java.util.Map;

public class TwinMetadata {
    public static final String LAST_UPDATE_TAG = "$lastUpdated";
    private Date lastUpdated;
    public static final String LAST_UPDATE_VERSION_TAG = "$lastUpdatedVersion";
    private final Integer lastUpdatedVersion;
    public static final String LAST_UPDATED_BY = "$lastUpdatedBy";
    private String lastUpdatedBy;
    public static final String LAST_UPDATED_BY_DIGEST = "$lastUpdatedByDigest";
    private String lastUpdatedByDigest;

    TwinMetadata(String lastUpdated, Integer lastUpdatedVersion, String lastUpdatedBy, String lastUpdatedByDigest) {
        if (!Tools.isNullOrEmpty(lastUpdated).booleanValue()) {
            this.lastUpdated = ParserUtility.getDateTimeUtc(lastUpdated);
        }
        if (lastUpdatedBy != null) {
            this.lastUpdatedBy = lastUpdatedBy;
        }
        if (lastUpdatedByDigest != null) {
            this.lastUpdatedByDigest = lastUpdatedByDigest;
        }
        this.lastUpdatedVersion = lastUpdatedVersion;
        if (this.lastUpdatedVersion == null && this.lastUpdated == null) {
            throw new IllegalArgumentException("no valid data to create a TwinMetadata.");
        }
    }

    TwinMetadata(TwinMetadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata to copy cannot be null");
        }
        this.lastUpdated = metadata.getLastUpdated();
        this.lastUpdatedVersion = metadata.getLastUpdatedVersion();
        this.lastUpdatedBy = metadata.getLastUpdatedBy();
        this.lastUpdatedByDigest = metadata.getLastUpdatedByDigest();
    }

    static TwinMetadata tryExtractFromMap(Object metadata) {
        if (!(metadata instanceof Map)) {
            return null;
        }
        String lastUpdated = null;
        Integer lastUpdatedVersion = null;
        String lastUpdatedBy = null;
        String lastUpdatedByDigest = null;
        for (Map.Entry entry : ((Map)metadata).entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals(LAST_UPDATE_TAG)) {
                lastUpdated = (String)entry.getValue();
                continue;
            }
            if (key.equals(LAST_UPDATE_VERSION_TAG)) {
                if (!(entry.getValue() instanceof Number)) {
                    throw new IllegalArgumentException("Version in the metadata shall be a number");
                }
                lastUpdatedVersion = ((Number)entry.getValue()).intValue();
                continue;
            }
            if (key.equals(LAST_UPDATED_BY)) {
                lastUpdatedBy = entry.getValue().toString();
                continue;
            }
            if (!key.equals(LAST_UPDATED_BY_DIGEST)) continue;
            lastUpdatedByDigest = entry.getValue().toString();
        }
        if (lastUpdatedVersion != null || !Tools.isNullOrEmpty(lastUpdated).booleanValue()) {
            return new TwinMetadata(lastUpdated, lastUpdatedVersion, lastUpdatedBy, lastUpdatedByDigest);
        }
        return null;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public String getLastUpdatedByDigest() {
        return this.lastUpdatedByDigest;
    }

    public Integer getLastUpdatedVersion() {
        return this.lastUpdatedVersion;
    }

    public Date getLastUpdated() {
        if (this.lastUpdated == null) {
            return null;
        }
        return new Date(this.lastUpdated.getTime());
    }

    JsonElement toJsonElement() {
        JsonObject jsonObject = new JsonObject();
        if (this.lastUpdated != null) {
            jsonObject.addProperty(LAST_UPDATE_TAG, ParserUtility.dateTimeUtcToString(this.lastUpdated));
        }
        if (this.lastUpdatedVersion != null) {
            jsonObject.addProperty(LAST_UPDATE_VERSION_TAG, (Number)this.lastUpdatedVersion);
        }
        if (this.lastUpdatedBy != null) {
            jsonObject.addProperty(LAST_UPDATED_BY, this.lastUpdatedBy);
        }
        if (this.lastUpdatedByDigest != null) {
            jsonObject.addProperty(LAST_UPDATED_BY_DIGEST, this.lastUpdatedByDigest);
        }
        return jsonObject;
    }

    public String toString() {
        return this.toJsonElement().toString();
    }
}

