/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.service.twin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.service.twin.ConfigurationInfo;
import com.microsoft.azure.sdk.iot.service.twin.DeviceCapabilities;
import com.microsoft.azure.sdk.iot.service.twin.Tools;
import com.microsoft.azure.sdk.iot.service.twin.TwinCollection;
import com.microsoft.azure.sdk.iot.service.twin.TwinConnectionState;
import com.microsoft.azure.sdk.iot.service.twin.TwinGsonBuilder;
import com.microsoft.azure.sdk.iot.service.twin.TwinProperties;
import com.microsoft.azure.sdk.iot.service.twin.TwinStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TwinState {
    private static final String DEVICE_ID_TAG = "deviceId";
    @Expose
    @SerializedName(value="deviceId")
    private String deviceId = null;
    private static final String MODULE_ID_TAG = "moduleId";
    @Expose
    @SerializedName(value="moduleId")
    private String moduleId = null;
    private static final String GENERATION_ID_TAG = "generationId";
    @Expose
    @SerializedName(value="generationId")
    private String generationId = null;
    private static final String ETAG_TAG = "etag";
    @Expose
    @SerializedName(value="etag")
    private String eTag = null;
    private static final String VERSION_TAG = "version";
    @Expose
    @SerializedName(value="version")
    private Integer version = null;
    private static final String STATUS_TAG = "status";
    @Expose
    @SerializedName(value="status")
    private TwinStatus status = null;
    private static final String STATUS_REASON_TAG = "statusReason";
    @Expose
    @SerializedName(value="statusReason")
    private String statusReason = null;
    private static final String STATUS_UPDATED_TIME_TAG = "statusUpdatedTime";
    @Expose
    @SerializedName(value="statusUpdatedTime")
    private String statusUpdatedTime = null;
    private static final String CONNECTION_STATE_TAG = "connectionState";
    @Expose
    @SerializedName(value="connectionState")
    protected TwinConnectionState connectionState = null;
    private static final String CONNECTION_STATE_UPDATED_TIME_TAG = "connectionStateUpdatedTime";
    @Expose
    @SerializedName(value="connectionStateUpdatedTime")
    private String connectionStateUpdatedTime = null;
    private static final String CLOUD_TO_DEVICE_MESSAGE_COUNT = "cloudToDeviceMessageCount";
    @Expose
    @SerializedName(value="cloudToDeviceMessageCount")
    private Integer cloudToDeviceMessageCount = null;
    private static final String LAST_ACTIVITY_TIME_TAG = "lastActivityTime";
    @Expose
    @SerializedName(value="lastActivityTime")
    private String lastActivityTime = null;
    private static final String CAPABILITIES_TAG = "capabilities";
    @Expose
    @SerializedName(value="capabilities")
    private DeviceCapabilities capabilities = null;
    private static final String MODEL_ID = "modelId";
    @Expose
    @SerializedName(value="modelId")
    private String modelId = null;
    private static final String TAGS_TAG = "tags";
    @Expose
    @SerializedName(value="tags")
    private TwinCollection tags;
    private static final String PROPERTIES_TAG = "properties";
    @Expose
    @SerializedName(value="properties")
    private TwinProperties properties;
    private static final String CONFIGURATION_TAG = "configurations";
    @Expose
    @SerializedName(value="configurations")
    private Map<String, ConfigurationInfo> configurations;
    private static final String DEVICE_SCOPE = "deviceScope";
    @SerializedName(value="deviceScope")
    private String deviceScope;
    private static final String PARENT_SCOPES = "parentScopes";
    @SerializedName(value="parentScopes")
    private final List<String> parentScopes = new ArrayList<String>();

    public TwinState(TwinCollection tags, TwinCollection desiredProperty, TwinCollection reportedProperty) {
        if (tags != null) {
            this.tags = TwinCollection.createFromRawCollection(tags);
        }
        if (desiredProperty != null || reportedProperty != null) {
            this.properties = new TwinProperties(desiredProperty, reportedProperty);
        }
    }

    public JsonElement toJsonElement() {
        Gson gson = TwinGsonBuilder.getGson();
        JsonObject json = gson.toJsonTree((Object)this).getAsJsonObject();
        if (json != null && this.properties != null) {
            json.getAsJsonObject().add(PROPERTIES_TAG, this.properties.toJsonElement());
        }
        return json;
    }

    public TwinCollection getTags() {
        return this.tags;
    }

    public TwinCollection getDesiredProperties() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getDesired();
    }

    public TwinCollection getReportedProperties() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getReported();
    }

    public String toString() {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().disableHtmlEscaping().create();
        JsonObject jsonObject = gson.toJsonTree((Object)this).getAsJsonObject();
        if (this.tags != null) {
            jsonObject.add(TAGS_TAG, this.tags.toJsonElementWithMetadata());
        }
        if (this.properties != null) {
            jsonObject.add(PROPERTIES_TAG, this.properties.toJsonElementWithMetadata());
        }
        return jsonObject.toString();
    }

    public TwinState(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = TwinGsonBuilder.getGson();
        TwinState result = (TwinState)gson.fromJson(json, TwinState.class);
        this.tags = new TwinCollection(result.getTags());
        if (result.properties != null) {
            this.properties = new TwinProperties(result.properties.getDesired(), result.properties.getReported());
        }
        this.configurations = result.configurations;
        this.deviceScope = result.deviceScope;
        this.parentScopes.addAll(result.parentScopes);
        this.connectionState = result.connectionState;
        this.setDeviceId(result.getDeviceId());
        this.setModuleId(result.getModuleId());
        this.setETag(result.getETag());
        this.setConnectionStateUpdatedTime(result.getConnectionStateUpdatedTime());
        this.setCapabilities(result.getCapabilities());
        this.setModelId(result.getModelId());
        this.setGenerationId(result.getGenerationId());
        this.setLastActivityTime(result.getLastActivityTime());
        this.setStatus(result.getStatus());
        this.setStatusReason(result.getStatusReason());
        this.setStatusUpdatedTime(result.getStatusUpdatedTime());
        this.setVersion(result.getVersion());
        this.setCloudToDeviceMessageCount(result.cloudToDeviceMessageCount);
    }

    public static TwinState createFromDesiredPropertyJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = TwinGsonBuilder.getGson();
        TwinCollection result = (TwinCollection)gson.fromJson(json, TwinCollection.class);
        return new TwinState(null, result, null);
    }

    public static TwinState createFromReportedPropertyJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = TwinGsonBuilder.getGson();
        TwinCollection result = (TwinCollection)gson.fromJson(json, TwinCollection.class);
        return new TwinState(null, null, result);
    }

    public static TwinState createFromPropertiesJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = TwinGsonBuilder.getGson();
        TwinProperties result = (TwinProperties)gson.fromJson(json, TwinProperties.class);
        return new TwinState(null, result.getDesired(), result.getReported());
    }

    public String getConnectionState() {
        if (this.connectionState == null) {
            return null;
        }
        return this.connectionState.toString();
    }

    TwinState() {
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getGenerationId() {
        return this.generationId;
    }

    public void setGenerationId(String generationId) {
        this.generationId = generationId;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public TwinStatus getStatus() {
        return this.status;
    }

    public void setStatus(TwinStatus status) {
        this.status = status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusUpdatedTime() {
        return this.statusUpdatedTime;
    }

    public void setStatusUpdatedTime(String statusUpdatedTime) {
        this.statusUpdatedTime = statusUpdatedTime;
    }

    public String getConnectionStateUpdatedTime() {
        return this.connectionStateUpdatedTime;
    }

    public void setConnectionStateUpdatedTime(String connectionStateUpdatedTime) {
        this.connectionStateUpdatedTime = connectionStateUpdatedTime;
    }

    public Integer getCloudToDeviceMessageCount() {
        return this.cloudToDeviceMessageCount;
    }

    public void setCloudToDeviceMessageCount(Integer cloudToDeviceMessageCount) {
        this.cloudToDeviceMessageCount = cloudToDeviceMessageCount;
    }

    public String getLastActivityTime() {
        return this.lastActivityTime;
    }

    public void setLastActivityTime(String lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
    }

    public DeviceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(DeviceCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public Map<String, ConfigurationInfo> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Map<String, ConfigurationInfo> configurations) {
        this.configurations = configurations;
    }

    public String getDeviceScope() {
        return this.deviceScope;
    }

    public void setDeviceScope(String deviceScope) {
        this.deviceScope = deviceScope;
    }

    public List<String> getParentScopes() {
        return this.parentScopes;
    }
}

