/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc.spark;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import com.microsoft.sqlserver.jdbc.spark.BulkCopyUtils$;
import com.microsoft.sqlserver.jdbc.spark.BulkCopyUtils$DataPoolTableType$;
import com.microsoft.sqlserver.jdbc.spark.ColumnMetadata;
import com.microsoft.sqlserver.jdbc.spark.DataFrameBulkRecord;
import com.microsoft.sqlserver.jdbc.spark.DataPoolUtils$;
import com.microsoft.sqlserver.jdbc.spark.SQLServerBulkJdbcOptions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class BulkCopyUtils$
implements Logging {
    public static final BulkCopyUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new BulkCopyUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    /*
     * Loose catch block
     */
    public void savePartition(Iterator<Row> iterator, String tableName, ColumnMetadata[] dfColMetadata, SQLServerBulkJdbcOptions options) {
        block11: {
            boolean committed;
            Connection conn;
            block10: {
                this.logDebug((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "savePartition:Entered";
                    }
                });
                conn = (Connection)JdbcUtils$.MODULE$.createConnectionFactory((JDBCOptions)options).apply();
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(options.isolationLevel());
                committed = false;
                this.logDebug((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "savePartition: Calling SQL Bulk Copy to write data";
                    }
                });
                SQLServerBulkCopy sqlServerBulkCopy = new SQLServerBulkCopy(conn);
                this.bulkWrite(iterator, tableName, sqlServerBulkCopy, dfColMetadata, options);
                conn.commit();
                committed = true;
                if (!committed) break block10;
                try {
                    conn.close();
                }
                catch (Exception exception) {
                    this.logWarning((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Transaction succeeded, but closing failed";
                        }
                    }, exception);
                }
            }
            conn.rollback();
            conn.close();
            break block11;
            catch (SQLException sQLException) {
                try {
                    this.handleException(sQLException);
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    if (committed) {
                        try {
                            conn.close();
                        }
                        catch (Exception exception) {
                            this.logWarning((Function0<String>)new /* invalid duplicate definition of identical inner class */, exception);
                        }
                        this.logDebug((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "savePartition :Exiting";
                            }
                        });
                    } else {
                        conn.rollback();
                        conn.close();
                    }
                    throw throwable;
                }
            }
            this.logDebug((Function0<String>)new /* invalid duplicate definition of identical inner class */);
        }
    }

    public void bulkWrite(Iterator<Row> iterator, String tableName, SQLServerBulkCopy sqlServerBulkCopy, ColumnMetadata[] dfColMetadata, SQLServerBulkJdbcOptions options) {
        this.logInfo((Function0<String>)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final SQLServerBulkJdbcOptions options$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bulkWrite: Tablock option is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.options$3.tableLock())}));
            }
            {
                this.options$3 = options$3;
            }
        });
        SQLServerBulkCopyOptions bulkConfig = this.getBulkCopyOptions(options);
        sqlServerBulkCopy.setBulkCopyOptions(bulkConfig);
        sqlServerBulkCopy.setDestinationTableName(tableName);
        DataFrameBulkRecord bulkRecord = new DataFrameBulkRecord(iterator, dfColMetadata);
        sqlServerBulkCopy.writeToServer((ISQLServerBulkRecord)bulkRecord);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleException(SQLException e) {
        SQLException cause = e.getNextException();
        if (cause == null) return;
        Throwable throwable = e.getCause();
        SQLException sQLException = cause;
        if (throwable == null) {
            if (sQLException == null) return;
        } else if (throwable.equals(sQLException)) return;
        if (e.getCause() != null) {
            e.addSuppressed(cause);
            return;
        }
        try {
            e.initCause(cause);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            e.addSuppressed(cause);
        }
    }

    public void checkIsolationLevel(Connection conn, SQLServerBulkJdbcOptions options) {
        if (conn.getMetaData().supportsTransactionIsolationLevel(options.isolationLevel())) {
            return;
        }
        conn.close();
        throw new SQLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Isolation level ", " not supported by SQL Server"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)options.isolationLevel())})));
    }

    public Dataset<Row> repartitionDataFrame(Dataset<Row> df, SQLServerBulkJdbcOptions options) {
        int n;
        boolean bl = false;
        Some some = null;
        Option option = options.numPartitions();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int n2 = BoxesRunTime.unboxToInt((Object)some.x());
            if (n2 <= 0) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "' for parameter 'numPartitions'\n                in table writing via JDBC. The minimum value is 1."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n2)})));
            }
        }
        Dataset dataset = bl && (n = BoxesRunTime.unboxToInt((Object)some.x())) < df.rdd().getNumPartitions() ? df.coalesce(n) : df;
        return dataset;
    }

    public ResultSet getEmptyResultSet(Connection conn, String table) {
        String queryStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM ", " WHERE 1=0;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}));
        return conn.createStatement().executeQuery(queryStr);
    }

    /*
     * WARNING - void declaration
     */
    public ColumnMetadata[] defaultColMetadataMap(ResultSetMetaData metadata) {
        void var2_2;
        ColumnMetadata[] result = new ColumnMetadata[metadata.getColumnCount()];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), metadata.getColumnCount() - 1).foreach$mVc$sp((Function1)new Serializable(metadata, result){
            public static final long serialVersionUID = 0L;
            private final ResultSetMetaData metadata$1;
            private final ColumnMetadata[] result$1;

            public final void apply(int idx) {
                this.apply$mcVI$sp(idx);
            }

            public void apply$mcVI$sp(int idx) {
                this.result$1[idx] = new ColumnMetadata(this.metadata$1.getColumnName(idx + 1), this.metadata$1.getColumnType(idx + 1), this.metadata$1.getPrecision(idx + 1), this.metadata$1.getScale(idx + 1), this.metadata$1.isAutoIncrement(idx + 1), idx);
            }
            {
                this.metadata$1 = metadata$1;
                this.result$1 = result$1;
            }
        });
        return var2_2;
    }

    public ColumnMetadata[] getColMetaData(Dataset<Row> df, Connection conn, SQLContext sqlContext, SQLServerBulkJdbcOptions options, boolean checkSchema) {
        ColumnMetadata[] columnMetadataArray;
        boolean isCaseSensitive = new StringOps(Predef$.MODULE$.augmentString(sqlContext.getConf("spark.sql.caseSensitive"))).toBoolean();
        ResultSet rs = this.getEmptyResultSet(conn, options.dbtable());
        if (checkSchema) {
            this.checkExTableType(conn, options);
            columnMetadataArray = this.matchSchemas(df, rs, options.url(), isCaseSensitive, options.schemaCheckEnabled());
        } else {
            columnMetadataArray = this.defaultColMetadataMap(rs.getMetaData());
        }
        ColumnMetadata[] colMetaData = columnMetadataArray;
        return colMetaData;
    }

    public ColumnMetadata[] matchSchemas(Dataset<Row> df, ResultSet rs, String url, boolean isCaseSensitive, boolean strictSchemaCheck) {
        Map dfColCaseMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String item) {
                return item.toLowerCase();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).zip((GenIterable)Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames()).toList(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        StructType dfCols = df.schema();
        StructType tableCols = JdbcUtils$.MODULE$.getSchema(rs, JdbcDialects$.MODULE$.get(url), JdbcUtils$.MODULE$.getSchema$default$3());
        String prefix = "Spark Dataframe and SQL Server table have differing";
        this.com$microsoft$sqlserver$jdbc$spark$BulkCopyUtils$$assertIfCheckEnabled(dfCols.length() == tableCols.length(), strictSchemaCheck, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " numbers of columns"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix})));
        ColumnMetadata[] result = new ColumnMetadata[tableCols.length()];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), tableCols.length() - 1).foreach$mVc$sp((Function1)new Serializable(rs, isCaseSensitive, strictSchemaCheck, dfColCaseMap, dfCols, tableCols, prefix, result){
            public static final long serialVersionUID = 0L;
            private final ResultSet rs$1;
            private final boolean isCaseSensitive$1;
            private final boolean strictSchemaCheck$1;
            private final Map dfColCaseMap$1;
            public final StructType dfCols$1;
            public final StructType tableCols$1;
            private final String prefix$1;
            private final ColumnMetadata[] result$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            /*
             * Unable to fully structure code
             */
            public void apply$mcVI$sp(int i) {
                tableColName = this.tableCols$1.apply(i).name();
                dfFieldIndex = IntRef.create((int)0);
                dfColName = "";
                if (this.isCaseSensitive$1) {
                    dfFieldIndex.elem = this.dfCols$1.fieldIndex(tableColName);
                    dfColName = this.dfCols$1.apply(dfFieldIndex.elem).name();
                    v0 = tableColName;
                    var5_5 = dfColName;
                    BulkCopyUtils$.MODULE$.com$microsoft$sqlserver$jdbc$spark$BulkCopyUtils$$assertIfCheckEnabled(!(v0 != null ? v0.equals(var5_5) == false : var5_5 != null), this.strictSchemaCheck$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column names '", "' and\n                     '", "' at column index ", " (case sensitive)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prefix$1, tableColName, dfColName, BoxesRunTime.boxToInteger((int)i)})));
                } else {
                    dfFieldIndex.elem = this.dfCols$1.fieldIndex((String)this.dfColCaseMap$1.apply((Object)tableColName.toLowerCase()));
                    dfColName = this.dfCols$1.apply(dfFieldIndex.elem).name();
                    v1 = tableColName.toLowerCase();
                    var6_6 = dfColName.toLowerCase();
                    BulkCopyUtils$.MODULE$.com$microsoft$sqlserver$jdbc$spark$BulkCopyUtils$$assertIfCheckEnabled(!(v1 != null ? v1.equals(var6_6) == false : var6_6 != null), this.strictSchemaCheck$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column names '", "' and\n                    '", "' at column index ", " (case insensitive)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prefix$1, tableColName, dfColName, BoxesRunTime.boxToInteger((int)i)})));
                }
                BulkCopyUtils$.MODULE$.logDebug((Function0<String>)new Serializable(this, dfFieldIndex, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.matchSchemas.1 $outer;
                    private final IntRef dfFieldIndex$1;
                    private final int i$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"matching Df column index ", " datatype ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.dfFieldIndex$1.elem), this.$outer.dfCols$1.apply(this.dfFieldIndex$1.elem).dataType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to table col index ", " datatype ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.i$1), this.$outer.tableCols$1.apply(this.i$1).dataType()}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.dfFieldIndex$1 = dfFieldIndex$1;
                        this.i$1 = i$1;
                    }
                });
                v2 = this.dfCols$1.apply(dfFieldIndex.elem).dataType();
                var7_7 = ByteType$.MODULE$;
                if (v2 != null ? v2.equals(var7_7) == false : var7_7 != null) ** GOTO lbl-1000
                v3 = this.tableCols$1.apply(i).dataType();
                var8_8 = ShortType$.MODULE$;
                if (!(v3 != null ? v3.equals(var8_8) == false : var8_8 != null)) {
                    BulkCopyUtils$.MODULE$.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Passing valid translation of ByteType to ShortType"})).s((Seq)Nil$.MODULE$);
                        }
                    });
                } else lbl-1000:
                // 2 sources

                {
                    v4 = this.dfCols$1.apply(dfFieldIndex.elem).dataType();
                    var9_9 = this.tableCols$1.apply(i).dataType();
                    BulkCopyUtils$.MODULE$.com$microsoft$sqlserver$jdbc$spark$BulkCopyUtils$$assertIfCheckEnabled(!(v4 != null ? v4.equals(var9_9) == false : var9_9 != null), this.strictSchemaCheck$1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column data types at column index ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prefix$1, BoxesRunTime.boxToInteger((int)i)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" DF col ", " dataType ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dfColName, this.dfCols$1.apply(dfFieldIndex.elem).dataType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Table col ", " dataType ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableColName, this.tableCols$1.apply(i).dataType()}))).toString());
                }
                BulkCopyUtils$.MODULE$.com$microsoft$sqlserver$jdbc$spark$BulkCopyUtils$$assertIfCheckEnabled(this.dfCols$1.apply(dfFieldIndex.elem).nullable() == this.tableCols$1.apply(i).nullable(), this.strictSchemaCheck$1, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column nullable configurations at column index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prefix$1, BoxesRunTime.boxToInteger((int)i)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" DF col ", " nullable config is ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dfColName, BoxesRunTime.boxToBoolean((boolean)this.dfCols$1.apply(dfFieldIndex.elem).nullable())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Table col ", " nullable config is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableColName, BoxesRunTime.boxToBoolean((boolean)this.tableCols$1.apply(i).nullable())}))).toString());
                this.result$2[i] = new ColumnMetadata(this.rs$1.getMetaData().getColumnName(i + 1), this.rs$1.getMetaData().getColumnType(i + 1), this.rs$1.getMetaData().getPrecision(i + 1), this.rs$1.getMetaData().getScale(i + 1), this.rs$1.getMetaData().isAutoIncrement(i + 1), dfFieldIndex.elem);
            }
            {
                this.rs$1 = rs$1;
                this.isCaseSensitive$1 = isCaseSensitive$1;
                this.strictSchemaCheck$1 = strictSchemaCheck$1;
                this.dfColCaseMap$1 = dfColCaseMap$1;
                this.dfCols$1 = dfCols$1;
                this.tableCols$1 = tableCols$1;
                this.prefix$1 = prefix$1;
                this.result$2 = result$2;
            }
        });
        return result;
    }

    public Tuple3<String, String, String> get3PartName(SQLServerBulkJdbcOptions options) {
        Tuple3 tuple3;
        String defaultSchema = "dbo";
        String[] tokens = new StringOps(Predef$.MODULE$.augmentString(options.dbtable())).split('.');
        int n = Predef$.MODULE$.refArrayOps((Object[])tokens).size();
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 1: {
                tuple3 = new Tuple3((Object)"", (Object)defaultSchema, (Object)tokens[0]);
                break;
            }
            case 2: {
                tuple3 = new Tuple3((Object)"", (Object)tokens[0], (Object)tokens[1]);
                break;
            }
            case 3: {
                tuple3 = new Tuple3((Object)tokens[0], (Object)tokens[1], (Object)tokens[2]);
            }
        }
        return tuple3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkExTableType(Connection conn, SQLServerBulkJdbcOptions options) {
        Tuple2 tuple2;
        if (!DataPoolUtils$.MODULE$.isDataPoolScenario(options)) return;
        Tuple3<String, String, String> tuple3 = this.get3PartName(options);
        if (tuple3 == null) throw new MatchError(tuple3);
        String schemaName = (String)tuple3._2();
        String tableName = (String)tuple3._3();
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)schemaName, (Object)tableName);
        String schemaName2 = (String)tuple22._1();
        String tableName2 = (String)tuple22._2();
        int tableType = this.getExternalTableType(conn, schemaName2, tableName2);
        String string = options.dataPoolDistPolicy();
        if ("REPLICATED".equals(string)) {
            this.assertCondition(tableType == BulkCopyUtils$DataPoolTableType$.MODULE$.REPLICATED_TABLES(), "External table is not of the type REPLICATED");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            if (!"ROUND_ROBIN".equals(string)) throw new SQLException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Invalid value in dataPoolDistPolicy ", "  .\n                           | Internal feature usage error:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.dataPoolDistPolicy()})))).stripMargin());
            this.assertCondition(tableType == BulkCopyUtils$DataPoolTableType$.MODULE$.ROUND_ROBIN_TABLES(), "External table is not of the type ROUND_ROBIN");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public int getExternalTableType(Connection conn, String schemaName, String tableName) {
        Statement stmt = conn.createStatement();
        String queryStr = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select distribution_type FROM sys.external_tables where "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"schema_name(schema_id)='", "' and name='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schemaName, tableName}))).toString();
        ResultSet rs = stmt.executeQuery(queryStr);
        rs.next();
        int tableType = rs.getInt("distribution_type");
        return tableType;
    }

    /*
     * WARNING - void declaration
     */
    public void executeUpdate(Connection conn, String updateString) {
        this.logDebug((Function0<String>)new Serializable(updateString){
            public static final long serialVersionUID = 0L;
            private final String updateString$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"execute update ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.updateString$1}));
            }
            {
                this.updateString$1 = updateString$1;
            }
        });
        Statement stmt = conn.createStatement();
        try {
            stmt.executeUpdate(updateString);
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "execute update success";
                }
            });
        }
        catch (Throwable throwable) {
            try {
                this.logError((Function0<String>)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable ex$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"execute update failed with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ex$1.getMessage()}));
                    }
                    {
                        this.ex$1 = ex$1;
                    }
                });
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var3_3;
                var3_3.close();
                throw throwable2;
            }
        }
        stmt.close();
    }

    public void mssqlTruncateTable(Connection conn, String dbtable) {
        this.logDebug((Function0<String>)new Serializable(dbtable){
            public static final long serialVersionUID = 0L;
            private final String dbtable$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncating table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dbtable$1}));
            }
            {
                this.dbtable$1 = dbtable$1;
            }
        });
        String truncateTableStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TRUNCATE TABLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbtable}));
        this.executeUpdate(conn, truncateTableStr);
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Truncating table succeeded";
            }
        });
    }

    public void mssqlCreateTable(Connection conn, Dataset<Row> df, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Creating table";
            }
        });
        String strSchema = JdbcUtils$.MODULE$.schemaString(df, options.url(), options.createTableColumnTypes());
        String createTableStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ") ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.dbtable(), strSchema, options.createTableOptions()}));
        this.executeUpdate(conn, createTableStr);
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Creating table succeeded";
            }
        });
    }

    public void mssqlCreateExTable(Connection conn, Dataset<Row> df, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final SQLServerBulkJdbcOptions options$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating external table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.options$2.dbtable()}));
            }
            {
                this.options$2 = options$2;
            }
        });
        String strSchema = JdbcUtils$.MODULE$.schemaString(df, "jdbc:sqlserver", JdbcUtils$.MODULE$.schemaString$default$3());
        String createExTableStr = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE EXTERNAL TABLE ", " (", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.dbtable(), strSchema}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WITH (DATA_SOURCE=", ", DISTRIBUTION=", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.dataPoolDataSource(), options.dataPoolDistPolicy()}))).toString();
        this.executeUpdate(conn, createExTableStr);
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Creating external table succeeded";
            }
        });
    }

    public void mssqlCreateDataSource(Connection conn, Dataset<Row> df, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final SQLServerBulkJdbcOptions options$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating datasource ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.options$1.dataPoolDataSource()}));
            }
            {
                this.options$1 = options$1;
            }
        });
        String externalDataPool = "sqldatapool://controller-svc/default";
        String createDSStr = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE EXTERNAL DATA SOURCE ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.dataPoolDataSource()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WITH (LOCATION = '", "');"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{externalDataPool}))).toString();
        this.executeUpdate(conn, createDSStr);
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Creating datasource succeeded";
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public boolean mssqlcheckDataSourceExists(Connection conn, Dataset<Row> df, SQLServerBulkJdbcOptions options) {
        boolean bl;
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Check if datasource exists";
            }
        });
        ObjectRef queryStr = ObjectRef.create((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT 1 FROM sys.external_data_sources WHERE name = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.dataPoolDataSource()})));
        this.logDebug((Function0<String>)new Serializable(queryStr){
            public static final long serialVersionUID = 0L;
            private final ObjectRef queryStr$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"queryString is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.queryStr$1.elem}));
            }
            {
                this.queryStr$1 = queryStr$1;
            }
        });
        Statement stmt = conn.createStatement();
        try {
            boolean isDataSrcPresent;
            ResultSet result = stmt.executeQuery((String)queryStr.elem);
            bl = isDataSrcPresent = result.next();
        }
        catch (Throwable throwable) {
            try {
                this.logError((Function0<String>)new Serializable(throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable ex$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check data source failed with error ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ex$2.getMessage()}));
                    }
                    {
                        this.ex$2 = ex$2;
                    }
                });
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var5_5;
                var5_5.close();
                throw throwable2;
            }
        }
        stmt.close();
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private SQLServerBulkCopyOptions getBulkCopyOptions(SQLServerBulkJdbcOptions options) {
        void var2_2;
        SQLServerBulkCopyOptions bulkCopyOptions = new SQLServerBulkCopyOptions();
        bulkCopyOptions.setBatchSize(options.batchSize());
        bulkCopyOptions.setBulkCopyTimeout(options.queryTimeout());
        bulkCopyOptions.setCheckConstraints(options.checkConstraints());
        bulkCopyOptions.setFireTriggers(options.fireTriggers());
        bulkCopyOptions.setKeepIdentity(options.keepIdentity());
        bulkCopyOptions.setKeepNulls(options.keepNulls());
        bulkCopyOptions.setTableLock(options.tableLock());
        bulkCopyOptions.setAllowEncryptedValueModifications(options.allowEncryptedValueModifications());
        return var2_2;
    }

    public String getDBNameFromURL(String url) {
        String token_sep = ";";
        int dbname_index = 1;
        String dbstring = url.split(token_sep)[dbname_index];
        String dbname = dbstring.split("=")[1];
        return dbname;
    }

    private void assertCondition(boolean cond, String msg) {
        try {
            Predef$.MODULE$.assert(cond);
            return;
        }
        catch (AssertionError assertionError) {
            throw new SQLException(msg);
        }
    }

    public void com$microsoft$sqlserver$jdbc$spark$BulkCopyUtils$$assertIfCheckEnabled(boolean cond, boolean checkEnabled, String msg) {
        if (checkEnabled) {
            this.assertCondition(cond, msg);
        } else {
            this.logInfo((Function0<String>)new Serializable(msg){
                public static final long serialVersionUID = 0L;
                private final String msg$1;

                public final String apply() {
                    return this.msg$1;
                }
                {
                    this.msg$1 = msg$1;
                }
            });
        }
    }

    private BulkCopyUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

