/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.microsoft.azure.spring.cloud.config.AppConfigurationProviderProperties;
import com.microsoft.azure.spring.cloud.config.resource.AppConfigManagedIdentityProperties;
import com.microsoft.azure.spring.cloud.config.stores.ConfigStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="spring.cloud.azure.appconfiguration")
@Import(value={AppConfigurationProviderProperties.class})
public class AppConfigurationProperties {
    public static final String CONFIG_PREFIX = "spring.cloud.azure.appconfiguration";
    public static final String LABEL_SEPARATOR = ",";
    private boolean enabled = true;
    private List<ConfigStore> stores = new ArrayList<ConfigStore>();
    @NotEmpty
    private String defaultContext = "application";
    @Nullable
    private String name;
    @NestedConfigurationProperty
    private AppConfigManagedIdentityProperties managedIdentity;
    @NotEmpty
    @Pattern(regexp="^[a-zA-Z0-9_@]+$")
    private @NotEmpty @Pattern(regexp="^[a-zA-Z0-9_@]+$") String profileSeparator = "_";
    private Duration cacheExpiration = Duration.ofSeconds(30L);

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<ConfigStore> getStores() {
        return this.stores;
    }

    public void setStores(List<ConfigStore> stores) {
        this.stores = stores;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public AppConfigManagedIdentityProperties getManagedIdentity() {
        return this.managedIdentity;
    }

    public void setManagedIdentity(AppConfigManagedIdentityProperties managedIdentity) {
        this.managedIdentity = managedIdentity;
    }

    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public Duration getCacheExpiration() {
        return this.cacheExpiration;
    }

    public void setCacheExpiration(Duration cacheExpiration) {
        this.cacheExpiration = cacheExpiration;
    }

    @PostConstruct
    public void validateAndInit() {
        Assert.notEmpty(this.stores, (String)"At least one config store has to be configured.");
        this.stores.forEach(store -> {
            Assert.isTrue((StringUtils.hasText((String)store.getEndpoint()) || StringUtils.hasText((String)store.getConnectionString()) ? 1 : 0) != 0, (String)"Either configuration store name or connection string should be configured.");
            store.validateAndInit();
        });
        int uniqueStoreSize = this.stores.stream().map(s -> s.getEndpoint()).distinct().collect(Collectors.toList()).size();
        Assert.isTrue((this.stores.size() == uniqueStoreSize ? 1 : 0) != 0, (String)"Duplicate store name exists.");
        Assert.isTrue((this.cacheExpiration.getSeconds() >= 1L ? 1 : 0) != 0, (String)"Minimum Watch time is 1 Second.");
    }
}

