/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.microsoft.azure.spring.cloud.config.AppConfigurationProperties;
import com.microsoft.azure.spring.cloud.config.AppConfigurationPropertySource;
import com.microsoft.azure.spring.cloud.config.AppConfigurationProviderProperties;
import com.microsoft.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.microsoft.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.microsoft.azure.spring.cloud.config.StateHolder;
import com.microsoft.azure.spring.cloud.config.feature.management.entity.FeatureSet;
import com.microsoft.azure.spring.cloud.config.stores.ClientStore;
import com.microsoft.azure.spring.cloud.config.stores.ConfigStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AppConfigurationPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPropertySourceLocator.class);
    private static final String SPRING_APP_NAME_PROP = "spring.application.name";
    private static final String PROPERTY_SOURCE_NAME = "azure-config-store";
    private static final String PATH_SPLITTER = "/";
    private final AppConfigurationProperties properties;
    private final String profileSeparator;
    private final List<ConfigStore> configStores;
    private final Map<String, List<String>> storeContextsMap = new ConcurrentHashMap<String, List<String>>();
    private AppConfigurationProviderProperties appProperties;
    private ClientStore clients;
    private KeyVaultCredentialProvider keyVaultCredentialProvider;
    private SecretClientBuilderSetup keyVaultClientProvider;
    private static Boolean startup = true;

    public AppConfigurationPropertySourceLocator(AppConfigurationProperties properties, AppConfigurationProviderProperties appProperties, ClientStore clients, KeyVaultCredentialProvider keyVaultCredentialProvider, SecretClientBuilderSetup keyVaultClientProvider) {
        this.properties = properties;
        this.appProperties = appProperties;
        this.profileSeparator = properties.getProfileSeparator();
        this.configStores = properties.getStores();
        this.clients = clients;
        this.keyVaultCredentialProvider = keyVaultCredentialProvider;
        this.keyVaultClientProvider = keyVaultClientProvider;
    }

    public PropertySource<?> locate(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return null;
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        String applicationName = this.properties.getName();
        if (!StringUtils.hasText((String)applicationName)) {
            applicationName = env.getProperty(SPRING_APP_NAME_PROP);
        }
        List<String> profiles = Arrays.asList(env.getActiveProfiles());
        CompositePropertySource composite = new CompositePropertySource(PROPERTY_SOURCE_NAME);
        Collections.reverse(this.configStores);
        Iterator<ConfigStore> configStoreIterator = this.configStores.iterator();
        while (configStoreIterator.hasNext()) {
            ConfigStore configStore = configStoreIterator.next();
            if (startup.booleanValue() || !startup.booleanValue() && StateHolder.getLoadState(configStore.getEndpoint()).booleanValue()) {
                this.addPropertySource(composite, configStore, applicationName, profiles, this.storeContextsMap, !configStoreIterator.hasNext());
                continue;
            }
            LOGGER.warn("Not loading configurations from {} as it failed on startup.", (Object)configStore.getEndpoint());
        }
        startup = false;
        return composite;
    }

    public Map<String, List<String>> getStoreContextsMap() {
        return this.storeContextsMap;
    }

    private void addPropertySource(CompositePropertySource composite, ConfigStore store, String applicationName, List<String> profiles, Map<String, List<String>> storeContextsMap, boolean initFeatures) {
        ArrayList<String> contexts = new ArrayList<String>();
        contexts.addAll(this.generateContexts(this.properties.getDefaultContext(), profiles, store));
        contexts.addAll(this.generateContexts(applicationName, profiles, store));
        FeatureSet featureSet = new FeatureSet();
        ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
        Collections.reverse(contexts);
        for (String sourceContext : contexts) {
            try {
                sourceList.addAll(this.create(sourceContext, store, storeContextsMap, initFeatures, featureSet));
                LOGGER.debug("PropertySource context [{}] is added.", (Object)sourceContext);
            }
            catch (Exception e) {
                if (store.isFailFast() || !startup.booleanValue()) {
                    LOGGER.error("Fail fast is set and there was an error reading configuration from Azure App Configuration store " + store.getEndpoint() + ". The configuration starting with " + sourceContext + " failed to load.");
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                } else {
                    LOGGER.warn("Unable to load configuration from Azure AppConfiguration store " + store.getEndpoint() + ". The configurations starting with " + sourceContext + "failed to load.", (Throwable)e);
                    StateHolder.setLoadState(store.getEndpoint(), false);
                }
                return;
            }
        }
        sourceList.forEach(arg_0 -> ((CompositePropertySource)composite).addPropertySource(arg_0));
    }

    private List<String> generateContexts(String applicationName, List<String> profiles, ConfigStore configStore) {
        ArrayList<String> result = new ArrayList<String>();
        if (!StringUtils.hasText((String)applicationName)) {
            return result;
        }
        String prefix = configStore.getPrefix();
        String prefixedContext = this.propWithAppName(prefix, applicationName);
        result.add(prefixedContext + PATH_SPLITTER);
        profiles.forEach(profile -> result.add(this.propWithProfile(prefixedContext, (String)profile)));
        return result;
    }

    private String propWithAppName(String prefix, String applicationName) {
        if (StringUtils.hasText((String)prefix)) {
            return prefix.startsWith(PATH_SPLITTER) ? prefix + PATH_SPLITTER + applicationName : PATH_SPLITTER + prefix + PATH_SPLITTER + applicationName;
        }
        return PATH_SPLITTER + applicationName;
    }

    private String propWithProfile(String context, String profile) {
        return context + this.profileSeparator + profile + PATH_SPLITTER;
    }

    private List<AppConfigurationPropertySource> create(String context, ConfigStore store, Map<String, List<String>> storeContextsMap, boolean initFeatures, FeatureSet featureSet) throws Exception {
        ArrayList<AppConfigurationPropertySource> sourceList = new ArrayList<AppConfigurationPropertySource>();
        try {
            for (String label : store.getLabels()) {
                this.putStoreContext(store.getEndpoint(), context, storeContextsMap);
                AppConfigurationPropertySource propertySource = new AppConfigurationPropertySource(context, store, label, this.properties, this.clients, this.appProperties, this.keyVaultCredentialProvider, this.keyVaultClientProvider);
                propertySource.initProperties(featureSet);
                if (initFeatures) {
                    propertySource.initFeatures(featureSet);
                }
                sourceList.add(propertySource);
            }
            String watchedKeyNames = this.clients.watchedKeyNames(store, storeContextsMap);
            SettingSelector settingSelector = new SettingSelector().setKeyFilter(watchedKeyNames).setLabelFilter("*");
            ConfigurationSetting configurationRevision = this.clients.getRevison(settingSelector, store.getEndpoint());
            settingSelector = new SettingSelector().setKeyFilter(".appconfig*").setLabelFilter("*");
            ConfigurationSetting featureRevision = this.clients.getRevison(settingSelector, store.getEndpoint());
            if (configurationRevision != null) {
                StateHolder.setEtagState(store.getEndpoint() + "_configuration", configurationRevision);
            } else {
                StateHolder.setEtagState(store.getEndpoint() + "_configuration", new ConfigurationSetting());
            }
            if (featureRevision != null) {
                StateHolder.setEtagState(store.getEndpoint() + "_feature", featureRevision);
            } else {
                StateHolder.setEtagState(store.getEndpoint() + "_feature", new ConfigurationSetting());
            }
            StateHolder.setLoadState(store.getEndpoint(), true);
        }
        catch (Exception e) {
            this.delayException();
            throw e;
        }
        return sourceList;
    }

    private void putStoreContext(String storeName, String context, @NonNull Map<String, List<String>> storeContextsMap) {
        if (!StringUtils.hasText((String)context) || !StringUtils.hasText((String)storeName)) {
            return;
        }
        List<String> contexts = storeContextsMap.get(storeName);
        if (contexts == null) {
            contexts = new ArrayList<String>();
        }
        contexts.add(context);
        storeContextsMap.put(storeName, contexts);
    }

    private void delayException() {
        Date currentDate = new Date();
        Date maxRetryDate = DateUtils.addSeconds((Date)this.appProperties.getStartDate(), (int)this.appProperties.getPrekillTime());
        if (currentDate.before(maxRetryDate)) {
            long diffInMillies = Math.abs(maxRetryDate.getTime() - currentDate.getTime());
            try {
                Thread.sleep(diffInMillies);
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to wait before fast fail.");
            }
        }
    }
}

