/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.microsoft.azure.spring.cloud.config.AppConfigurationProperties;
import com.microsoft.azure.spring.cloud.config.StateHolder;
import com.microsoft.azure.spring.cloud.config.stores.ClientStore;
import com.microsoft.azure.spring.cloud.config.stores.ConfigStore;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component
public class AppConfigurationRefresh
implements ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationRefresh.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ApplicationEventPublisher publisher;
    private final List<ConfigStore> configStores;
    private final Map<String, List<String>> storeContextsMap;
    private Duration delay;
    private ClientStore clientStore;
    private Date lastCheckedTime;
    private String eventDataInfo;

    public AppConfigurationRefresh(AppConfigurationProperties properties, Map<String, List<String>> storeContextsMap, ClientStore clientStore) {
        this.configStores = properties.getStores();
        this.storeContextsMap = storeContextsMap;
        this.delay = properties.getCacheExpiration();
        this.lastCheckedTime = new Date();
        this.clientStore = clientStore;
        this.eventDataInfo = "";
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @Async
    public Future<Boolean> refreshConfigurations() {
        return new AsyncResult((Object)this.refreshStores());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshStores() {
        boolean willRefresh = false;
        if (this.running.compareAndSet(false, true)) {
            try {
                Date notCachedTime = null;
                if (this.lastCheckedTime != null) {
                    notCachedTime = DateUtils.addSeconds((Date)this.lastCheckedTime, (int)Math.toIntExact(this.delay.getSeconds()));
                }
                Date date = new Date();
                if (notCachedTime == null || date.after(notCachedTime)) {
                    for (ConfigStore configStore : this.configStores) {
                        if (StateHolder.getLoadState(configStore.getEndpoint()).booleanValue()) {
                            String watchedKeyNames = this.clientStore.watchedKeyNames(configStore, this.storeContextsMap);
                            willRefresh = this.refresh(configStore, "_configuration", watchedKeyNames) ? true : willRefresh;
                            willRefresh = this.refresh(configStore, "_feature", ".appconfig*") ? true : willRefresh;
                            continue;
                        }
                        LOGGER.debug("Skipping refresh check for " + configStore.getEndpoint() + ". The store failed to load on startup.");
                    }
                    this.lastCheckedTime = new Date();
                }
                if (willRefresh) {
                    if (this.eventDataInfo.equals("*")) {
                        LOGGER.info("Configuration Refresh event triggered by store modification.");
                    } else {
                        LOGGER.info("Configuration Refresh Event triggered by " + this.eventDataInfo);
                    }
                    RefreshEventData eventData = new RefreshEventData(this.eventDataInfo);
                    this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)eventData, eventData.getMessage()));
                }
            }
            finally {
                this.running.set(false);
            }
        }
        return willRefresh;
    }

    private boolean refresh(ConfigStore store, String storeSuffix, String watchedKeyNames) {
        String storeNameWithSuffix = store.getEndpoint() + storeSuffix;
        SettingSelector settingSelector = new SettingSelector().setKeyFilter(watchedKeyNames).setLabelFilter("*");
        ConfigurationSetting revision = this.clientStore.getRevison(settingSelector, store.getEndpoint());
        String etag = null;
        if (revision != null) {
            etag = revision.getETag();
        }
        if (StateHolder.getEtagState(storeNameWithSuffix) == null) {
            if (etag != null) {
                LOGGER.info("The store " + store.getEndpoint() + " had no keys on startup, but now has keys to load.");
                return true;
            }
            return false;
        }
        if (etag != null && !etag.equals(StateHolder.getEtagState(storeNameWithSuffix).getETag())) {
            LOGGER.trace("Some keys in store [{}] matching [{}] is updated, will send refresh event.", (Object)store.getEndpoint(), (Object)watchedKeyNames);
            this.eventDataInfo = this.eventDataInfo.isEmpty() ? watchedKeyNames : this.eventDataInfo + ", " + watchedKeyNames;
            return true;
        }
        return false;
    }

    class RefreshEventData {
        private static final String MSG_TEMPLATE = "Some keys matching %s has been updated since last check.";
        private final String message;

        public RefreshEventData(String prefix) {
            this.message = String.format(MSG_TEMPLATE, prefix);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

