/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config.stores;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.microsoft.azure.spring.cloud.config.AppConfigurationProperties;
import com.microsoft.azure.spring.cloud.config.KeyVaultCredentialProvider;
import com.microsoft.azure.spring.cloud.config.SecretClientBuilderSetup;
import com.microsoft.azure.spring.cloud.config.resource.AppConfigManagedIdentityProperties;
import java.net.URI;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;

public class KeyVaultClient {
    private SecretAsyncClient secretClient;
    private AppConfigurationProperties properties;
    private SecretClientBuilderSetup keyVaultClientProvider;
    private URI uri;
    private TokenCredential tokenCredential;

    public KeyVaultClient(AppConfigurationProperties properties, URI uri, KeyVaultCredentialProvider tokenCredentialProvider, SecretClientBuilderSetup keyVaultClientProvider) {
        this.properties = properties;
        this.uri = uri;
        if (tokenCredentialProvider != null) {
            this.tokenCredential = tokenCredentialProvider.getKeyVaultCredential("https://" + uri.getHost());
        }
        this.keyVaultClientProvider = keyVaultClientProvider;
    }

    KeyVaultClient build() {
        SecretClientBuilder builder = this.getBuilder();
        AppConfigManagedIdentityProperties msiProps = this.properties.getManagedIdentity();
        String fullUri = "https://" + this.uri.getHost();
        if (this.tokenCredential != null && msiProps != null) {
            throw new IllegalArgumentException("More than 1 Conncetion method was set for connecting to Key Vault.");
        }
        if (this.tokenCredential != null) {
            builder.credential(this.tokenCredential);
        } else if (this.tokenCredential == null && msiProps != null && StringUtils.isNotEmpty((CharSequence)msiProps.getClientId())) {
            builder.credential((TokenCredential)new ManagedIdentityCredentialBuilder().clientId(msiProps.getClientId()).build());
        } else if (this.tokenCredential == null) {
            builder.credential((TokenCredential)new ManagedIdentityCredentialBuilder().build());
        }
        builder.vaultUrl(fullUri);
        if (this.keyVaultClientProvider != null) {
            this.keyVaultClientProvider.setup(builder, fullUri);
        }
        this.secretClient = builder.buildAsyncClient();
        return this;
    }

    public KeyVaultSecret getSecret(URI secretIdentifier, int timeout) {
        String[] tokens;
        if (this.secretClient == null) {
            this.build();
        }
        String name = (tokens = secretIdentifier.getPath().split("/")).length >= 3 ? tokens[2] : null;
        String version = tokens.length >= 4 ? tokens[3] : null;
        return (KeyVaultSecret)this.secretClient.getSecret(name, version).block(Duration.ofSeconds(timeout));
    }

    SecretClientBuilder getBuilder() {
        return new SecretClientBuilder();
    }
}

