/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.sql;

import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.spring.cloud.autoconfigure.sql.AbstractJdbcDatasourcePropertiesUpdater;
import com.microsoft.azure.spring.cloud.autoconfigure.sql.AzureSqlProperties;
import com.microsoft.azure.spring.cloud.autoconfigure.sql.DatabaseType;
import com.microsoft.azure.spring.cloud.autoconfigure.sql.JdbcDataSourcePropertiesUpdater;
import com.microsoft.azure.spring.cloud.context.core.AzureAdmin;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class SqlServerJdbcDataSourcePropertiesUpdater
extends AbstractJdbcDatasourcePropertiesUpdater
implements JdbcDataSourcePropertiesUpdater {
    public SqlServerJdbcDataSourcePropertiesUpdater(AzureSqlProperties azureSqlProperties, AzureAdmin azureAdmin) {
        super(azureSqlProperties, DatabaseType.SQLSERVER, azureAdmin);
    }

    @Override
    String getUserName() {
        SqlServer sqlServer = this.azureAdmin.getSqlServer(this.azureSqlProperties.getServerName());
        if (sqlServer == null) {
            throw new IllegalArgumentException("SqlServer not found. If you want to auto create sqlServer. Please provide username and password");
        }
        return sqlServer.administratorLogin();
    }

    @Override
    String getUrl(DataSourceProperties dataSourceProperties) {
        SqlServer sqlServer = this.azureAdmin.getOrCreateSqlServer(dataSourceProperties.getUsername(), dataSourceProperties.getPassword(), this.azureSqlProperties.getServerName());
        this.azureAdmin.getOrCreateSqlDatabase(this.azureSqlProperties.getServerName(), this.azureSqlProperties.getDatabaseName());
        return String.format(this.databaseType.getJdbcUrlTemplate(), sqlServer.fullyQualifiedDomainName(), this.azureSqlProperties.getDatabaseName());
    }
}

