/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.telemetry;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryProperties;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class})
@PropertySource(value={"classpath:telemetry.config"})
@EnableConfigurationProperties(value={TelemetryProperties.class})
@ConditionalOnProperty(name={"spring.cloud.azure.telemetry.enable"}, matchIfMissing=true)
@ConditionalOnClass(value={TelemetryClient.class})
public class TelemetryAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(name={"telemetry.instrumentationKey"})
    public TelemetryTracker telemetryTracker(Azure azure, TelemetryProperties telemetryProperties) {
        try {
            return new TelemetryTracker(azure.getCurrentSubscription().subscriptionId(), telemetryProperties.getInstrumentationKey());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid argument to build telemetry tracker");
            return null;
        }
    }
}

