/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.cloudfoundry;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;

enum AzureCfService {
    SERVICEBUS("servicebus", "azure-servicebus", (Map<String, String>)ImmutableMap.of((Object)"connectionString", (Object)"connection-string")),
    EVENTHUB("eventhub", "azure-eventhubs", (Map<String, String>)ImmutableMap.of((Object)"connectionString", (Object)"connection-string")),
    STORAGE("storage", "azure-storage", (Map<String, String>)ImmutableMap.of((Object)"storageAccountName", (Object)"account", (Object)"accessKey", (Object)"access-key")),
    STORAGE_EVENTHUB("eventhub", "azure-storage", (Map<String, String>)ImmutableMap.of((Object)"storageAccountName", (Object)"checkpoint-storage-account", (Object)"accessKey", (Object)"checkpoint-access-key")),
    REDIS("spring.redis", "azure-rediscache", (Map<String, String>)ImmutableMap.of((Object)"host", (Object)"host", (Object)"password", (Object)"password", (Object)"port", (Object)"port"), false);

    private static final String SPRING_CLOUD_AZURE_PROPERTY_PREFIX = "spring.cloud.azure.";
    private final String cfServiceName;
    private final String azureServiceName;
    private final Map<String, String> cfToAzureProperties;
    private final boolean isAzureProperty;

    private AzureCfService(String azureServiceName, String cfServiceName, Map<String, String> cfToAzureProperties) {
        this(azureServiceName, cfServiceName, cfToAzureProperties, true);
    }

    private AzureCfService(String azureServiceName, String cfServiceName, Map<String, String> cfToAzureProperties, boolean isAzureProperty) {
        this.cfServiceName = cfServiceName;
        this.azureServiceName = azureServiceName;
        this.isAzureProperty = isAzureProperty;
        this.cfToAzureProperties = this.buildCfToAzureProperties(cfToAzureProperties);
    }

    public String getCfServiceName() {
        return this.cfServiceName;
    }

    public Map<String, String> getCfToAzureProperties() {
        return this.cfToAzureProperties;
    }

    public String getAzureServiceName() {
        return this.azureServiceName;
    }

    private Map<String, String> buildCfToAzureProperties(Map<String, String> cfToAzureProperties) {
        return cfToAzureProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getPropertyPrefix() + (String)e.getValue()));
    }

    private String getPropertyPrefix() {
        if (this.isAzureProperty) {
            return SPRING_CLOUD_AZURE_PROPERTY_PREFIX + this.azureServiceName + ".";
        }
        return this.azureServiceName + ".";
    }
}

