/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.jms;

import com.microsoft.azure.spring.cloud.autoconfigure.jms.ServiceBusKey;
import java.util.HashMap;

public class ConnectionStringResolver {
    private static final String ENDPOINT = "Endpoint";
    private static final String HOST = "host";
    private static final String SAS_KEY_NAME = "SharedAccessKeyName";
    private static final String SAS_KEY = "SharedAccessKey";

    public static ServiceBusKey getServiceBusKey(String connectionString) {
        String[] segments = connectionString.split(";");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String segment : segments) {
            int indexOfEqualSign = segment.indexOf("=");
            String key = segment.substring(0, indexOfEqualSign);
            String value = segment.substring(indexOfEqualSign + 1);
            hashMap.put(key, value);
        }
        String endpoint = (String)hashMap.get(ENDPOINT);
        String[] segmentsOfEndpoint = endpoint.split("/");
        String host = segmentsOfEndpoint[segmentsOfEndpoint.length - 1];
        hashMap.put(HOST, host);
        return new ServiceBusKey((String)hashMap.get(HOST), (String)hashMap.get(SAS_KEY_NAME), (String)hashMap.get(SAS_KEY));
    }
}

