/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.telemetry;

import java.net.InetAddress;
import java.net.NetworkInterface;
import org.apache.commons.codec.digest.DigestUtils;

public class MacAddressHelper {
    private static final String UNKNOWN_MAC = "Unknown-Mac-Address";
    private static final String hashedMacAddress = MacAddressHelper.computeHashedMacAddress();

    private static String computeHashedMacAddress() {
        try {
            InetAddress host = InetAddress.getLocalHost();
            byte[] macBytes = NetworkInterface.getByInetAddress(host).getHardwareAddress();
            return DigestUtils.sha256Hex((byte[])macBytes);
        }
        catch (Exception ignore) {
            return UNKNOWN_MAC;
        }
    }

    public static String getHashedMacAddress() {
        return hashedMacAddress;
    }
}

