/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.telemetry;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class TelemetryEventData {
    private final String name = "Microsoft.ApplicationInsights.Event";
    @JsonProperty(value="iKey")
    private final String instrumentationKey;
    private final Tags tags = new Tags();
    private final EventData data = new EventData();
    private final String time = Instant.now().toString();

    public TelemetryEventData(String eventName, @NonNull Map<String, String> properties, String instrumentationKey) {
        Assert.hasText((String)eventName, (String)"Event name should contain text.");
        Assert.hasText((String)instrumentationKey, (String)"Instrumentation key should contain text.");
        this.instrumentationKey = instrumentationKey;
        this.data.getBaseData().setName(eventName);
        this.data.getBaseData().setProperties(properties);
    }

    public String getName() {
        return "Microsoft.ApplicationInsights.Event";
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    public Tags getTags() {
        return this.tags;
    }

    public EventData getData() {
        return this.data;
    }

    public String getTime() {
        return this.time;
    }

    private static class EventData {
        private final String baseType = "EventData";
        private final CustomData baseData = new CustomData();

        private EventData() {
        }

        public CustomData getBaseData() {
            return this.baseData;
        }

        public String getBaseType() {
            return "EventData";
        }

        private static class CustomData {
            private final Integer ver = 2;
            private String name;
            private Map<String, String> properties;

            private CustomData() {
            }

            public Integer getVer() {
                return this.ver;
            }

            public String getName() {
                return this.name;
            }

            public Map<String, String> getProperties() {
                return this.properties;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setProperties(Map<String, String> properties) {
                this.properties = properties;
            }
        }
    }

    private static class Tags {
        @JsonProperty(value="ai.cloud.roleInstance")
        private final String aiCloudRoleInstance = "Spring-on-azure";
        @JsonProperty(value="ai.internal.sdkVersion")
        private final String aiInternalSdkVersion = "Java-maven-plugin";

        private Tags() {
        }

        public String getAiCloudRoleInstance() {
            return "Spring-on-azure";
        }

        public String getAiInternalSdkVersion() {
            return "Java-maven-plugin";
        }
    }
}

