/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.cache;

import com.microsoft.azure.management.redis.RedisCache;
import com.microsoft.azure.spring.cloud.autoconfigure.cache.AzureRedisProperties;
import com.microsoft.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryCollector;
import com.microsoft.azure.spring.cloud.context.core.api.ResourceManagerProvider;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.RedisOperations;

@Configuration
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.azure.redis.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={RedisOperations.class})
@ConditionalOnBean(value={ResourceManagerProvider.class})
@EnableConfigurationProperties(value={AzureRedisProperties.class})
public class AzureRedisAutoConfiguration {
    private static final String REDIS = "Redis";

    @PostConstruct
    public void collectTelemetry() {
        TelemetryCollector.getInstance().addService(REDIS);
    }

    @ConditionalOnMissingBean
    @Primary
    @Bean
    public RedisProperties redisProperties(ResourceManagerProvider resourceManagerProvider, AzureRedisProperties azureRedisProperties) {
        boolean isCluster;
        String cacheName = azureRedisProperties.getName();
        RedisCache redisCache = (RedisCache)resourceManagerProvider.getRedisCacheManager().getOrCreate((Object)cacheName);
        RedisProperties redisProperties = new RedisProperties();
        boolean useSsl = !redisCache.nonSslPort();
        int port = useSsl ? redisCache.sslPort() : redisCache.port();
        boolean bl = isCluster = redisCache.shardCount() > 0;
        if (isCluster) {
            RedisProperties.Cluster cluster = new RedisProperties.Cluster();
            cluster.setNodes(Arrays.asList(redisCache.hostName() + ":" + port));
            redisProperties.setCluster(cluster);
        } else {
            redisProperties.setHost(redisCache.hostName());
            redisProperties.setPort(port);
        }
        redisProperties.setPassword(redisCache.getKeys().primaryKey());
        redisProperties.setSsl(useSsl);
        return redisProperties;
    }
}

