/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.jms;

import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="spring.cloud.azure.servicebus.jms")
public class AzureServiceBusJMSProperties {
    private String connectionString;
    private String clientId;
    private int idleTimeout = 3600000;

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @PostConstruct
    public void validate() {
        if (!StringUtils.hasText((String)this.connectionString)) {
            throw new IllegalArgumentException("'spring.cloud.azure.servicebus.jms.connection-string' should be provided");
        }
        if (!StringUtils.hasText((String)this.clientId)) {
            throw new IllegalArgumentException("'spring.cloud.azure.servicebus.jms.client-id' should be provided");
        }
        if (!StringUtils.hasText((String)(this.idleTimeout + ""))) {
            throw new IllegalArgumentException("'spring.cloud.azure.servicebus.jms.idle-timeout' should be provided");
        }
    }
}

