/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.telemetry;

import com.microsoft.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryCollector;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryProperties;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetrySender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class})
@PropertySource(value={"classpath:telemetry.config"})
@EnableConfigurationProperties(value={TelemetryProperties.class})
@ConditionalOnProperty(name={"spring.cloud.azure.telemetry.enabled"}, matchIfMissing=true)
@ConditionalOnExpression(value="'${telemetry.instrumentationKey}' != '@telemetry.instrumentationKey@'")
public class TelemetryAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TelemetryAutoConfiguration.class);

    @Bean
    public TelemetrySender telemetrySender(TelemetryProperties telemetryProperties) {
        try {
            return new TelemetrySender(telemetryProperties.getInstrumentationKey(), TelemetryCollector.getInstance());
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid argument to build telemetry tracker");
            return null;
        }
    }
}

