/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.telemetry;

import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryCollector;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryRestClient;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class TelemetrySender {
    private static final Logger log = LoggerFactory.getLogger(TelemetrySender.class);
    private static final int INSTRUMENTATION_KEY_LENGTH = 36;
    private final TelemetryRestClient telemetryRestClient;
    private final TelemetryCollector collector;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public TelemetrySender(String instrumentKey, @NonNull TelemetryCollector collector) {
        this.telemetryRestClient = TelemetrySender.buildTelemetryRestClient(instrumentKey);
        this.collector = collector;
        this.scheduler.scheduleAtFixedRate(this::sendEvent, 0L, 1L, TimeUnit.HOURS);
    }

    private static TelemetryRestClient buildTelemetryRestClient(String instrumentationKey) {
        if (!TelemetrySender.isValid(instrumentationKey)) {
            log.warn("Telemetry instrumentationKey {} is invalid", (Object)instrumentationKey);
            throw new IllegalArgumentException("Telemetry instrumentationKey is invalid");
        }
        return new TelemetryRestClient(instrumentationKey);
    }

    private static boolean isValid(String instrumentationKey) {
        return StringUtils.hasText((String)instrumentationKey) && instrumentationKey.length() == 36;
    }

    private void sendEvent() {
        this.collector.getProperties().forEach(m -> {
            log.info("Sending telemetry event with properties {}", m);
            this.telemetryRestClient.send(this.collector.getName(), (Map<String, String>)m);
        });
    }
}

