/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.context.core.impl;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.spring.cloud.context.core.config.AzureProperties;
import com.microsoft.azure.spring.cloud.context.core.impl.AzureManager;
import com.microsoft.azure.spring.cloud.context.core.util.Tuple;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.queue.CloudQueue;
import com.microsoft.azure.storage.queue.CloudQueueClient;
import java.net.URISyntaxException;

public class StorageQueueManager
extends AzureManager<CloudQueue, Tuple<CloudStorageAccount, String>> {
    public StorageQueueManager(Azure azure, AzureProperties azureProperties) {
        super(azure, azureProperties);
    }

    @Override
    String getResourceName(Tuple<CloudStorageAccount, String> key) {
        return key.getSecond();
    }

    @Override
    String getResourceType() {
        return CloudQueue.class.getSimpleName();
    }

    @Override
    public CloudQueue internalGet(Tuple<CloudStorageAccount, String> key) {
        CloudQueueClient queueClient = key.getFirst().createCloudQueueClient();
        try {
            CloudQueue cloudQueue = queueClient.getQueueReference(key.getSecond());
            if (!cloudQueue.exists()) {
                return null;
            }
            return cloudQueue;
        }
        catch (StorageException | URISyntaxException e) {
            throw new RuntimeException("Failed to build queue client", e);
        }
    }

    @Override
    public CloudQueue internalCreate(Tuple<CloudStorageAccount, String> key) {
        CloudQueueClient queueClient = key.getFirst().createCloudQueueClient();
        try {
            CloudQueue cloudQueue = queueClient.getQueueReference(key.getSecond());
            cloudQueue.create();
            return cloudQueue;
        }
        catch (StorageException | URISyntaxException e) {
            throw new RuntimeException("Failed to build queue client", e);
        }
    }
}

