/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.context.core.config;

import com.google.common.base.Strings;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.spring.cloud.context.core.api.CredentialSupplier;
import com.microsoft.azure.spring.cloud.context.core.config.AzureManagedIdentityProperties;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="spring.cloud.azure")
public class AzureProperties
implements CredentialSupplier {
    private String credentialFilePath;
    private String resourceGroup;
    private AzureEnvironment environment = AzureEnvironment.AZURE;
    private String region;
    private boolean autoCreateResources = false;
    private boolean msiEnabled = false;
    @NestedConfigurationProperty
    private AzureManagedIdentityProperties managedIdentity;
    private String subscriptionId;

    @PostConstruct
    private void validate() {
        if (this.autoCreateResources) {
            Assert.hasText((String)this.region, (String)"When auto create resources is enabled, spring.cloud.azure.region must be provided");
        }
        if (this.msiEnabled && Strings.isNullOrEmpty((String)this.subscriptionId)) {
            Assert.hasText((String)this.region, (String)"When msi is enabled, spring.cloud.azure.subscription-id must be provided");
        }
    }

    @Override
    public String getCredentialFilePath() {
        return this.credentialFilePath;
    }

    public void setCredentialFilePath(String credentialFilePath) {
        this.credentialFilePath = credentialFilePath;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public AzureEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(AzureEnvironment environment) {
        this.environment = environment;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean isAutoCreateResources() {
        return this.autoCreateResources;
    }

    public void setAutoCreateResources(boolean autoCreateResources) {
        this.autoCreateResources = autoCreateResources;
    }

    @Override
    public boolean isMsiEnabled() {
        return this.msiEnabled;
    }

    public void setMsiEnabled(boolean msiEnabled) {
        this.msiEnabled = msiEnabled;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public AzureManagedIdentityProperties getManagedIdentity() {
        return this.managedIdentity;
    }

    public void setManagedIdentity(AzureManagedIdentityProperties managedIdentity) {
        this.managedIdentity = managedIdentity;
    }
}

