/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhub.stream.binder.properties;

import com.microsoft.azure.eventhub.stream.binder.properties.EventHubBindingProperties;
import com.microsoft.azure.eventhub.stream.binder.properties.EventHubConsumerProperties;
import com.microsoft.azure.eventhub.stream.binder.properties.EventHubProducerProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;

@ConfigurationProperties(value="spring.cloud.stream.eventhub")
public class EventHubExtendedBindingProperties
implements ExtendedBindingProperties<EventHubConsumerProperties, EventHubProducerProperties> {
    private static final String DEFAULTS_PREFIX = "spring.cloud.stream.eventhub.default";
    private Map<String, EventHubBindingProperties> bindings = new ConcurrentHashMap<String, EventHubBindingProperties>();
    private String checkpointStorageAccount;

    public EventHubConsumerProperties getExtendedConsumerProperties(String channelName) {
        return this.bindings.computeIfAbsent(channelName, key -> new EventHubBindingProperties()).getConsumer();
    }

    public EventHubProducerProperties getExtendedProducerProperties(String channelName) {
        return this.bindings.computeIfAbsent(channelName, key -> new EventHubBindingProperties()).getProducer();
    }

    public String getDefaultsPrefix() {
        return DEFAULTS_PREFIX;
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return EventHubBindingProperties.class;
    }

    public String getCheckpointStorageAccount() {
        return this.checkpointStorageAccount;
    }

    public void setCheckpointStorageAccount(String checkpointStorageAccount) {
        this.checkpointStorageAccount = checkpointStorageAccount;
    }

    public Map<String, EventHubBindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, EventHubBindingProperties> bindings) {
        this.bindings = bindings;
    }
}

