/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhub.stream.binder.provisioning;

import com.microsoft.azure.eventhub.stream.binder.provisioning.EventHubChannelProvisioner;
import com.microsoft.azure.management.eventhub.EventHub;
import com.microsoft.azure.management.eventhub.EventHubNamespace;
import com.microsoft.azure.spring.cloud.context.core.api.ResourceManagerProvider;
import com.microsoft.azure.spring.cloud.context.core.util.Tuple;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class EventHubChannelResourceManagerProvisioner
extends EventHubChannelProvisioner {
    private final String namespace;
    private final ResourceManagerProvider resourceManagerProvider;

    public EventHubChannelResourceManagerProvisioner(@NonNull ResourceManagerProvider resourceManagerProvider, @NonNull String namespace) {
        Assert.hasText((String)namespace, (String)"The namespace can't be null or empty");
        this.namespace = namespace;
        this.resourceManagerProvider = resourceManagerProvider;
    }

    @Override
    protected void validateOrCreateForConsumer(String name, String group) {
        EventHubNamespace eventHubNamespace = (EventHubNamespace)this.resourceManagerProvider.getEventHubNamespaceManager().getOrCreate((Object)this.namespace);
        EventHub eventHub = (EventHub)this.resourceManagerProvider.getEventHubManager().get((Object)Tuple.of((Object)eventHubNamespace, (Object)name));
        if (eventHub == null) {
            throw new ProvisioningException(String.format("Event hub with name '%s' in namespace '%s' not existed", name, this.namespace));
        }
        this.resourceManagerProvider.getEventHubConsumerGroupManager().getOrCreate((Object)Tuple.of((Object)eventHub, (Object)group));
    }

    @Override
    protected void validateOrCreateForProducer(String name) {
        if (this.resourceManagerProvider == null) {
            return;
        }
        EventHubNamespace eventHubNamespace = (EventHubNamespace)this.resourceManagerProvider.getEventHubNamespaceManager().getOrCreate((Object)this.namespace);
        this.resourceManagerProvider.getEventHubManager().getOrCreate((Object)Tuple.of((Object)eventHubNamespace, (Object)name));
    }
}

