/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.feature.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.microsoft.azure.spring.cloud.feature.manager.FeatureFilter;
import com.microsoft.azure.spring.cloud.feature.manager.FeatureManagementConfigProperties;
import com.microsoft.azure.spring.cloud.feature.manager.FilterNotFoundException;
import com.microsoft.azure.spring.cloud.feature.manager.entities.Feature;
import com.microsoft.azure.spring.cloud.feature.manager.entities.FeatureFilterEvaluationContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Mono;

@Component(value="FeatureManagement")
@ConfigurationProperties(prefix="feature-management")
public class FeatureManager
extends HashMap<String, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureManager.class);
    @Autowired
    private ApplicationContext context;
    private FeatureManagementConfigProperties properties;
    private HashMap<String, Feature> featureManagement;
    private HashMap<String, Boolean> onOff;
    private ObjectMapper mapper = new ObjectMapper();

    public FeatureManager(FeatureManagementConfigProperties properties) {
        this.properties = properties;
        this.featureManagement = new HashMap();
        this.onOff = new HashMap();
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategy.KEBAB_CASE);
    }

    public Mono<Boolean> isEnabledAsync(String feature) throws FilterNotFoundException {
        return Mono.just((Object)this.checkFeatures(feature));
    }

    private boolean checkFeatures(String feature) throws FilterNotFoundException {
        boolean enabled = false;
        if (this.featureManagement == null || this.onOff == null) {
            return false;
        }
        Feature featureItem = this.featureManagement.get(feature);
        Boolean boolFeature = this.onOff.get(feature);
        if (boolFeature != null) {
            return boolFeature;
        }
        if (featureItem == null) {
            return false;
        }
        for (FeatureFilterEvaluationContext filter : featureItem.getEnabledFor().values()) {
            block7: {
                if (filter != null && filter.getName() != null) {
                    try {
                        FeatureFilter featureFilter = (FeatureFilter)this.context.getBean(filter.getName());
                        enabled = (Boolean)Mono.just((Object)featureFilter.evaluate(filter)).block();
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        LOGGER.error("Was unable to find Filter " + filter.getName() + ". Does the class exist and set as an @Component?");
                        if (!this.properties.isFailFast()) break block7;
                        String message = "Fail fast is set and a Filter was unable to be found";
                        ReflectionUtils.rethrowRuntimeException((Throwable)new FilterNotFoundException(message, e, filter));
                    }
                }
            }
            if (!enabled) continue;
            return enabled;
        }
        return enabled;
    }

    private void addToFeatures(Map<? extends String, ? extends Object> features, String key, String combined) {
        Object featureKey = features.get(key);
        if (!combined.isEmpty() && !combined.endsWith(".")) {
            combined = combined + ".";
        }
        if (featureKey instanceof Boolean) {
            this.onOff.put(combined + key, (Boolean)featureKey);
        } else {
            Feature feature = null;
            try {
                feature = (Feature)this.mapper.convertValue(featureKey, Feature.class);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Found invalid feature {} with value {}.", (Object)(combined + key), (Object)featureKey.toString());
            }
            if (feature != null && feature.getEnabledFor() == null && feature.getKey() == null) {
                if (LinkedHashMap.class.isAssignableFrom(featureKey.getClass())) {
                    features = (LinkedHashMap)featureKey;
                    for (String fKey : features.keySet()) {
                        this.addToFeatures(features, fKey, combined + key);
                    }
                }
            } else if (feature != null) {
                feature.setKey(key);
                this.featureManagement.put(key, feature);
            }
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        if (m == null) {
            return;
        }
        for (String string : m.keySet()) {
            this.addToFeatures(m, string, "");
        }
    }

    public Set<String> getAllFeatureNames() {
        HashSet<String> allFeatures = new HashSet<String>();
        allFeatures.addAll(this.onOff.keySet());
        allFeatures.addAll(this.featureManagement.keySet());
        return allFeatures;
    }

    HashMap<String, Feature> getFeatureManagement() {
        return this.featureManagement;
    }

    HashMap<String, Boolean> getOnOff() {
        return this.onOff;
    }
}

