/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.feature.manager.feature.filters;

import com.microsoft.azure.spring.cloud.feature.manager.FeatureFilter;
import com.microsoft.azure.spring.cloud.feature.manager.entities.FeatureFilterEvaluationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="PercentageFilter")
public class PercentageFilter
implements FeatureFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PercentageFilter.class);

    @Override
    public boolean evaluate(FeatureFilterEvaluationContext context) {
        String value = (String)context.getParameters().get("percentage-filter-setting");
        boolean result = true;
        if (value == null || Double.valueOf(value) < 0.0) {
            LOGGER.warn("The {} feature filter does not have a valid {} value for feature {}.", new Object[]{this.getClass().getSimpleName(), "percentage-filter-setting", context.getName()});
            result = false;
        } else {
            result = Math.random() * 100.0 <= Double.valueOf(value);
        }
        return result;
    }
}

