/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.feature.manager.feature.filters;

import com.microsoft.azure.spring.cloud.feature.manager.FeatureFilter;
import com.microsoft.azure.spring.cloud.feature.manager.entities.FeatureFilterEvaluationContext;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="TimeWindowFilter")
public class TimeWindowFilter
implements FeatureFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeWindowFilter.class);

    @Override
    public boolean evaluate(FeatureFilterEvaluationContext context) {
        String start = (String)context.getParameters().get("time-window-filter-setting-start");
        String end = (String)context.getParameters().get("time-window-filter-setting-end");
        ZonedDateTime now = ZonedDateTime.now();
        if (!StringUtils.hasText((String)start) && !StringUtils.hasText((String)end)) {
            LOGGER.warn("The {} feature filter is not valid for feature {}. It must specify either {}, {}, or both.", new Object[]{this.getClass().getSimpleName(), context.getName(), "time-window-filter-setting-start", "time-window-filter-setting-end"});
            return false;
        }
        ZonedDateTime startTime = StringUtils.hasText((String)start) ? ZonedDateTime.parse(start, DateTimeFormatter.RFC_1123_DATE_TIME) : null;
        ZonedDateTime endTime = StringUtils.hasText((String)end) ? ZonedDateTime.parse(end, DateTimeFormatter.RFC_1123_DATE_TIME) : null;
        return !(StringUtils.hasText((String)start) && !now.isAfter(startTime) || StringUtils.hasText((String)end) && !now.isBefore(endTime));
    }
}

