/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.stream.binder.provisioning;

import com.microsoft.azure.management.servicebus.Queue;
import com.microsoft.azure.management.servicebus.ServiceBusNamespace;
import com.microsoft.azure.servicebus.stream.binder.provisioning.ServiceBusChannelProvisioner;
import com.microsoft.azure.spring.cloud.context.core.api.ResourceManagerProvider;
import com.microsoft.azure.spring.cloud.context.core.util.Tuple;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class ServiceBusQueueChannelResourceManagerProvisioner
extends ServiceBusChannelProvisioner {
    private final ResourceManagerProvider resourceManagerProvider;
    private final String namespace;

    public ServiceBusQueueChannelResourceManagerProvisioner(@NonNull ResourceManagerProvider resourceManagerProvider, @NonNull String namespace) {
        Assert.hasText((String)namespace, (String)"The namespace can't be null or empty");
        this.resourceManagerProvider = resourceManagerProvider;
        this.namespace = namespace;
    }

    protected void validateOrCreateForConsumer(String name, String group) {
        ServiceBusNamespace namespace = (ServiceBusNamespace)this.resourceManagerProvider.getServiceBusNamespaceManager().getOrCreate((Object)this.namespace);
        Queue queue = (Queue)this.resourceManagerProvider.getServiceBusQueueManager().getOrCreate((Object)Tuple.of((Object)namespace, (Object)name));
        if (queue == null) {
            throw new ProvisioningException(String.format("Event hub with name '%s' in namespace '%s' not existed", name, namespace));
        }
    }

    protected void validateOrCreateForProducer(String name) {
        ServiceBusNamespace namespace = (ServiceBusNamespace)this.resourceManagerProvider.getServiceBusNamespaceManager().getOrCreate((Object)this.namespace);
        this.resourceManagerProvider.getServiceBusQueueManager().getOrCreate((Object)Tuple.of((Object)namespace, (Object)name));
    }
}

