/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.storage;

import org.springframework.util.Assert;

final class AzureStorageUtils {
    private static final String BLOB_PROTOCOL_PREFIX = "blob://";
    private static final String PATH_DELIMITER = "/";

    private AzureStorageUtils() {
    }

    static boolean isAzureStorageResource(String location) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        return location.toLowerCase().startsWith(BLOB_PROTOCOL_PREFIX);
    }

    static String getContainerName(String location) {
        AzureStorageUtils.assertIsAzureStorageLocation(location);
        int containerEndIndex = AzureStorageUtils.assertContainerValid(location);
        return location.substring(BLOB_PROTOCOL_PREFIX.length(), containerEndIndex);
    }

    static String getBlobName(String location) {
        AzureStorageUtils.assertIsAzureStorageLocation(location);
        int containerEndIndex = AzureStorageUtils.assertContainerValid(location);
        if (location.endsWith(PATH_DELIMITER)) {
            return location.substring(++containerEndIndex, location.length() - 1);
        }
        return location.substring(++containerEndIndex, location.length());
    }

    private static void assertIsAzureStorageLocation(String location) {
        if (!AzureStorageUtils.isAzureStorageResource(location)) {
            throw new IllegalArgumentException(String.format("The location '%s' is not a valid Azure blob location", location));
        }
    }

    private static int assertContainerValid(String location) {
        int containerEndIndex = location.indexOf(PATH_DELIMITER, BLOB_PROTOCOL_PREFIX.length());
        if (containerEndIndex == -1 || containerEndIndex == BLOB_PROTOCOL_PREFIX.length()) {
            throw new IllegalArgumentException(String.format("The location '%s' does not contain a valid container name", location));
        }
        return containerEndIndex;
    }
}

