/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.storage;

import com.microsoft.azure.spring.cloud.storage.AzureStorageUtils;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

public class BlobStorageResource
extends AbstractResource
implements WritableResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStorageResource.class);
    private final CloudBlobClient blobClient;
    private final String location;
    private final CloudBlobContainer blobContainer;
    private final CloudBlockBlob blockBlob;
    private final boolean autoCreateFiles;

    public BlobStorageResource(CloudBlobClient blobClient, String location) {
        this(blobClient, location, false);
    }

    public BlobStorageResource(CloudBlobClient blobClient, String location, boolean autoCreateFiles) {
        this.autoCreateFiles = autoCreateFiles;
        AzureStorageUtils.isAzureStorageResource(location);
        this.blobClient = blobClient;
        this.location = location;
        try {
            this.blobContainer = blobClient.getContainerReference(AzureStorageUtils.getContainerName(location));
            this.blockBlob = this.blobContainer.getBlockBlobReference(AzureStorageUtils.getBlobName(location));
        }
        catch (StorageException | URISyntaxException e) {
            LOGGER.error("Failed to get cloud blob or container ", e);
            throw new RuntimeException("Failed to get cloud blob or container", e);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            if (!this.exists()) {
                if (this.autoCreateFiles) {
                    this.create();
                } else {
                    throw new FileNotFoundException("The blob was not found: " + this.location);
                }
            }
            return this.blockBlob.openOutputStream();
        }
        catch (StorageException e) {
            LOGGER.error("Failed to open output stream of cloud blob", (Throwable)e);
            throw new IOException("Failed to open output stream of cloud blob");
        }
    }

    public boolean exists() {
        try {
            return this.blobContainer.exists() && this.blockBlob.exists();
        }
        catch (StorageException e) {
            LOGGER.error("Failed to check existence of cloud blob or container", (Throwable)e);
            return false;
        }
    }

    public URL getURL() throws IOException {
        return this.getURI().toURL();
    }

    public URI getURI() throws IOException {
        return this.blockBlob.getStorageUri().getPrimaryUri();
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    public long contentLength() throws IOException {
        return this.blockBlob.getProperties().getLength();
    }

    public long lastModified() throws IOException {
        return this.blockBlob.getProperties().getLastModified().getTime();
    }

    public Resource createRelative(String relativePath) throws IOException {
        String newLocation = this.location + "/" + relativePath;
        return new BlobStorageResource(this.blobClient, newLocation, this.autoCreateFiles);
    }

    public String getFilename() {
        return this.blockBlob.getName();
    }

    public String getDescription() {
        return String.format("Azure storage account block blob resource [container='%s', blob='%s']", this.blobContainer.getName(), this.blockBlob.getName());
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.assertExisted();
            return this.blockBlob.openInputStream();
        }
        catch (StorageException e) {
            LOGGER.error("Failed to open input stream of cloud blob", (Throwable)e);
            throw new IOException("Failed to open input stream of cloud blob");
        }
    }

    private void assertExisted() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException("Blob or container not existed.");
        }
    }

    private void create() throws StorageException {
        this.blobContainer.createIfNotExists();
    }
}

