/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.storage;

import com.microsoft.azure.spring.cloud.storage.AzureStorageUtils;
import com.microsoft.azure.spring.cloud.storage.BlobStorageResource;
import com.microsoft.azure.spring.cloud.storage.FileStorageResource;
import com.microsoft.azure.spring.cloud.storage.StorageType;
import com.microsoft.azure.storage.CloudStorageAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class AzureStorageProtocolResolver
implements ProtocolResolver,
BeanFactoryPostProcessor,
ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(AzureStorageProtocolResolver.class);
    private ConfigurableListableBeanFactory beanFactory;
    private CloudStorageAccount cloudStorageAccount;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        if (DefaultResourceLoader.class.isAssignableFrom(resourceLoader.getClass())) {
            ((DefaultResourceLoader)resourceLoader).addProtocolResolver((ProtocolResolver)this);
        } else {
            log.warn("Custom Protocol using azure-blob:// or azure-file:// prefix will not be enabled.");
        }
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (AzureStorageUtils.isAzureStorageResource(location, StorageType.BLOB)) {
            return new BlobStorageResource(this.getCloudStorageAccount().createCloudBlobClient(), location, true);
        }
        if (AzureStorageUtils.isAzureStorageResource(location, StorageType.FILE)) {
            return new FileStorageResource(this.getCloudStorageAccount().createCloudFileClient(), location, true);
        }
        return null;
    }

    private CloudStorageAccount getCloudStorageAccount() {
        if (this.cloudStorageAccount == null) {
            this.cloudStorageAccount = (CloudStorageAccount)this.beanFactory.getBean(CloudStorageAccount.class);
        }
        return this.cloudStorageAccount;
    }
}

