/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.storage;

import com.microsoft.azure.spring.cloud.storage.StorageType;
import org.springframework.util.Assert;

final class AzureStorageUtils {
    private static final String STORAGE_PROTOCOL_PREFIX = "azure-%s://";

    AzureStorageUtils() {
    }

    static boolean isAzureStorageResource(String location, StorageType storageType) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        return location.toLowerCase().startsWith(AzureStorageUtils.getStorageProtocolPrefix(storageType));
    }

    static String getStorageProtocolPrefix(StorageType storageType) {
        return String.format(STORAGE_PROTOCOL_PREFIX, storageType.getType());
    }
}

