/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.storage;

import com.microsoft.azure.spring.cloud.storage.AzureStorageResource;
import com.microsoft.azure.spring.cloud.storage.StorageRuntimeException;
import com.microsoft.azure.spring.cloud.storage.StorageType;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class BlobStorageResource
extends AzureStorageResource {
    private static final Logger log = LoggerFactory.getLogger(BlobStorageResource.class);
    private static final String MSG_FAIL_GET = "Failed to get blob or container";
    private static final String MSG_FAIL_OPEN_OUTPUT = "Failed to open output stream of cloud blob";
    private static final String MSG_FAIL_CHECK_EXIST = "Failed to check existence of blob or container";
    private static final String MSG_FAIL_OPEN_INPUT = "Failed to open input stream of blob";
    private final CloudBlobClient blobClient;
    private final String location;
    private final CloudBlobContainer blobContainer;
    private final CloudBlockBlob blockBlob;
    private final boolean autoCreateFiles;

    BlobStorageResource(CloudBlobClient blobClient, String location) {
        this(blobClient, location, false);
    }

    BlobStorageResource(CloudBlobClient blobClient, String location, boolean autoCreateFiles) {
        this.assertIsAzureStorageLocation(location);
        this.autoCreateFiles = autoCreateFiles;
        this.blobClient = blobClient;
        this.location = location;
        try {
            this.blobContainer = blobClient.getContainerReference(this.getContainerName(location));
            this.blockBlob = this.blobContainer.getBlockBlobReference(this.getFileName(location));
        }
        catch (StorageException | URISyntaxException e) {
            log.error(MSG_FAIL_GET, e);
            throw new StorageRuntimeException(MSG_FAIL_GET, e);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            if (!this.exists()) {
                if (this.autoCreateFiles) {
                    this.create();
                } else {
                    throw new FileNotFoundException("The blob was not found: " + this.location);
                }
            }
            return this.blockBlob.openOutputStream();
        }
        catch (StorageException e) {
            log.error(MSG_FAIL_OPEN_OUTPUT, (Throwable)e);
            throw new IOException(MSG_FAIL_OPEN_OUTPUT, e);
        }
    }

    public boolean exists() {
        try {
            return this.blobContainer.exists() && this.blockBlob.exists();
        }
        catch (StorageException e) {
            log.error(MSG_FAIL_CHECK_EXIST, (Throwable)e);
            throw new StorageRuntimeException(MSG_FAIL_CHECK_EXIST, e);
        }
    }

    public URL getURL() throws IOException {
        return this.getURI().toURL();
    }

    public URI getURI() throws IOException {
        return this.blockBlob.getStorageUri().getPrimaryUri();
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    public long contentLength() throws IOException {
        return this.blockBlob.getProperties().getLength();
    }

    public long lastModified() throws IOException {
        return this.blockBlob.getProperties().getLastModified().getTime();
    }

    public Resource createRelative(String relativePath) throws IOException {
        String newLocation = this.location + "/" + relativePath;
        return new BlobStorageResource(this.blobClient, newLocation, this.autoCreateFiles);
    }

    public String getFilename() {
        return this.blockBlob.getName();
    }

    public String getDescription() {
        return String.format("Azure storage account blob resource [container='%s', blob='%s']", this.blobContainer.getName(), this.blockBlob.getName());
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.assertExisted();
            return this.blockBlob.openInputStream();
        }
        catch (StorageException e) {
            log.error(MSG_FAIL_OPEN_INPUT, (Throwable)e);
            throw new IOException(MSG_FAIL_OPEN_INPUT);
        }
    }

    @Override
    StorageType getStorageType() {
        return StorageType.BLOB;
    }

    private void assertExisted() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException("Blob or container not existed.");
        }
    }

    private void create() throws StorageException {
        this.blobContainer.createIfNotExists();
    }
}

