/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.storage;

import com.microsoft.azure.spring.cloud.storage.AzureStorageResource;
import com.microsoft.azure.spring.cloud.storage.StorageRuntimeException;
import com.microsoft.azure.spring.cloud.storage.StorageType;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.file.CloudFile;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.file.CloudFileShare;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class FileStorageResource
extends AzureStorageResource {
    private static final Logger log = LoggerFactory.getLogger(FileStorageResource.class);
    private static final String MSG_FAIL_GET = "Failed to get file or container";
    private static final String MSG_FAIL_OPEN_OUTPUT = "Failed to open output stream of file";
    private static final String MSG_FAIL_CHECK_EXIST = "Failed to check existence of file or container";
    private static final String MSG_FAIL_OPEN_INPUT = "Failed to open input stream of file";
    private final CloudFileClient fileClient;
    private final String location;
    private final CloudFile cloudFile;
    private final boolean autoCreateFiles;
    private final CloudFileShare fileShare;

    public FileStorageResource(CloudFileClient fileClient, String location) {
        this(fileClient, location, false);
    }

    FileStorageResource(CloudFileClient fileClient, String location, boolean autoCreateFiles) {
        this.assertIsAzureStorageLocation(location);
        this.autoCreateFiles = autoCreateFiles;
        this.fileClient = fileClient;
        this.location = location;
        try {
            this.fileShare = fileClient.getShareReference(this.getContainerName(location));
            this.cloudFile = this.fileShare.getRootDirectoryReference().getFileReference(this.getFileName(location));
        }
        catch (StorageException | URISyntaxException e) {
            log.error(MSG_FAIL_GET, e);
            throw new RuntimeException(MSG_FAIL_GET, e);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            if (!this.exists()) {
                if (this.autoCreateFiles) {
                    this.create();
                } else {
                    throw new FileNotFoundException("The file was not found: " + this.location);
                }
            }
            return this.cloudFile.openWriteExisting();
        }
        catch (StorageException | URISyntaxException e) {
            log.error(MSG_FAIL_OPEN_OUTPUT, e);
            throw new IOException(MSG_FAIL_OPEN_OUTPUT, e);
        }
    }

    public boolean exists() {
        try {
            return this.fileShare.exists() && this.cloudFile.exists();
        }
        catch (StorageException e) {
            log.error(MSG_FAIL_CHECK_EXIST, (Throwable)e);
            throw new StorageRuntimeException(MSG_FAIL_CHECK_EXIST, e);
        }
    }

    public URL getURL() throws IOException {
        return this.getURI().toURL();
    }

    public URI getURI() throws IOException {
        return this.cloudFile.getStorageUri().getPrimaryUri();
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    public long contentLength() throws IOException {
        return this.cloudFile.getProperties().getLength();
    }

    public long lastModified() throws IOException {
        return this.cloudFile.getProperties().getLastModified().getTime();
    }

    public Resource createRelative(String relativePath) throws IOException {
        String newLocation = this.location + "/" + relativePath;
        return new FileStorageResource(this.fileClient, newLocation, this.autoCreateFiles);
    }

    public String getFilename() {
        return this.cloudFile.getName();
    }

    public String getDescription() {
        return String.format("Azure storage account file resource [container='%s', file='%s']", this.fileShare.getName(), this.cloudFile.getName());
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.assertExisted();
            return this.cloudFile.openRead();
        }
        catch (StorageException e) {
            log.error("Failed to open input stream of cloud file", (Throwable)e);
            throw new IOException("Failed to open input stream of cloud file");
        }
    }

    @Override
    StorageType getStorageType() {
        return StorageType.FILE;
    }

    private void assertExisted() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException("File or container not existed.");
        }
    }

    private void create() throws StorageException, URISyntaxException {
        this.fileShare.createIfNotExists();
        this.cloudFile.create(1024L);
    }
}

