/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.storage;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.microsoft.azure.spring.cloud.storage.AzureStorageResource;
import com.microsoft.azure.spring.cloud.storage.StorageType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class BlobStorageResource
extends AzureStorageResource {
    private static final Logger log = LoggerFactory.getLogger(BlobStorageResource.class);
    private static final String MSG_FAIL_GET = "Failed to get blob or container";
    private static final String MSG_FAIL_OPEN_OUTPUT = "Failed to open output stream of cloud blob";
    private static final String MSG_FAIL_CHECK_EXIST = "Failed to check existence of blob or container";
    private static final String MSG_FAIL_OPEN_INPUT = "Failed to open input stream of blob";
    private final BlobServiceClient blobServiceClient;
    private final String location;
    private final BlobContainerClient blobContainerClient;
    private final BlockBlobClient blockBlobClient;
    private final boolean autoCreateFiles;

    BlobStorageResource(BlobServiceClient blobServiceClient, String location) {
        this(blobServiceClient, location, false);
    }

    BlobStorageResource(BlobServiceClient blobServiceClient, String location, boolean autoCreateFiles) {
        this.assertIsAzureStorageLocation(location);
        this.autoCreateFiles = autoCreateFiles;
        this.blobServiceClient = blobServiceClient;
        this.location = location;
        this.blobContainerClient = blobServiceClient.getBlobContainerClient(this.getContainerName(location));
        this.blockBlobClient = this.blobContainerClient.getBlobClient(this.getFilename(location)).getBlockBlobClient();
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            if (!this.exists()) {
                if (this.autoCreateFiles) {
                    this.create();
                } else {
                    throw new FileNotFoundException("The blob was not found: " + this.location);
                }
            }
            return this.blockBlobClient.getBlobOutputStream();
        }
        catch (BlobStorageException e) {
            log.error(MSG_FAIL_OPEN_OUTPUT, (Throwable)e);
            throw new IOException(MSG_FAIL_OPEN_OUTPUT, e);
        }
    }

    public boolean exists() {
        return this.blobContainerClient.exists() && this.blockBlobClient.exists() != false;
    }

    public URL getURL() throws IOException {
        return new URL(this.blockBlobClient.getBlobUrl());
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    public long contentLength() throws IOException {
        return this.blockBlobClient.getProperties().getBlobSize();
    }

    public long lastModified() throws IOException {
        return this.blockBlobClient.getProperties().getLastModified().toEpochSecond();
    }

    public Resource createRelative(String relativePath) throws IOException {
        String newLocation = this.location + "/" + relativePath;
        return new BlobStorageResource(this.blobServiceClient, newLocation, this.autoCreateFiles);
    }

    public String getFilename() {
        return this.blockBlobClient.getBlobName();
    }

    public String getDescription() {
        return String.format("Azure storage account blob resource [container='%s', blob='%s']", this.blockBlobClient.getContainerName(), this.blockBlobClient.getBlobName());
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.assertExisted();
            return this.blockBlobClient.openInputStream();
        }
        catch (BlobStorageException e) {
            log.error(MSG_FAIL_OPEN_INPUT, (Throwable)e);
            throw new IOException(MSG_FAIL_OPEN_INPUT);
        }
    }

    @Override
    StorageType getStorageType() {
        return StorageType.BLOB;
    }

    private void assertExisted() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException("Blob or container not existed.");
        }
    }

    private void create() {
        if (!this.blobContainerClient.exists()) {
            this.blobContainerClient.create();
        }
    }
}

