/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.storage;

import com.azure.storage.queue.QueueServiceClient;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.microsoft.azure.spring.cloud.autoconfigure.context.AzureEnvironmentAutoConfiguration;
import com.microsoft.azure.spring.cloud.autoconfigure.storage.AzureStorageProperties;
import com.microsoft.azure.spring.cloud.context.core.api.EnvironmentProvider;
import com.microsoft.azure.spring.cloud.context.core.api.ResourceManagerProvider;
import com.microsoft.azure.spring.cloud.context.core.storage.StorageConnectionStringProvider;
import com.microsoft.azure.spring.cloud.telemetry.TelemetryCollector;
import com.microsoft.azure.spring.integration.storage.queue.StorageQueueOperation;
import com.microsoft.azure.spring.integration.storage.queue.StorageQueueTemplate;
import com.microsoft.azure.spring.integration.storage.queue.factory.DefaultStorageQueueClientFactory;
import com.microsoft.azure.spring.integration.storage.queue.factory.StorageQueueClientFactory;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class, AzureEnvironmentAutoConfiguration.class})
@ConditionalOnClass(value={QueueServiceClient.class, StorageQueueClientFactory.class})
@ConditionalOnProperty(name={"spring.cloud.azure.storage.account"})
@EnableConfigurationProperties(value={AzureStorageProperties.class})
public class AzureStorageQueueAutoConfiguration {
    private static final String STORAGE_QUEUE = "StorageQueue";
    private static final String STORAGE = "Storage";
    private static final String ACCOUNT_NAME = "AccountName";
    @Autowired(required=false)
    private ResourceManagerProvider resourceManagerProvider;

    @PostConstruct
    public void collectTelemetry() {
        TelemetryCollector.getInstance().addService(STORAGE_QUEUE);
    }

    @Bean
    @ConditionalOnMissingBean
    StorageQueueClientFactory storageQueueClientFactory(AzureStorageProperties storageProperties, EnvironmentProvider environmentProvider) {
        String connectionString;
        if (this.resourceManagerProvider != null) {
            String accountName = storageProperties.getAccount();
            StorageAccount storageAccount = (StorageAccount)this.resourceManagerProvider.getStorageAccountManager().getOrCreate((Object)accountName);
            connectionString = StorageConnectionStringProvider.getConnectionString((StorageAccount)storageAccount, (AzureEnvironment)environmentProvider.getEnvironment(), (boolean)storageProperties.isSecureTransfer());
        } else {
            connectionString = StorageConnectionStringProvider.getConnectionString((String)storageProperties.getAccount(), (String)storageProperties.getAccessKey(), (AzureEnvironment)environmentProvider.getEnvironment());
        }
        return new DefaultStorageQueueClientFactory(connectionString);
    }

    @Bean
    @ConditionalOnMissingBean
    StorageQueueOperation storageQueueOperation(StorageQueueClientFactory storageQueueClientFactory) {
        return new StorageQueueTemplate(storageQueueClientFactory);
    }
}

