/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.storage.actuator;

import com.microsoft.azure.spring.cloud.autoconfigure.storage.AzureStorageAutoConfiguration;
import com.microsoft.azure.spring.cloud.autoconfigure.storage.AzureStorageQueueAutoConfiguration;
import com.microsoft.azure.spring.cloud.autoconfigure.storage.actuator.BlobStorageHealthIndicator;
import com.microsoft.azure.spring.cloud.autoconfigure.storage.actuator.FileStorageHealthIndicator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AzureStorageAutoConfiguration.class, AzureStorageQueueAutoConfiguration.class})
@ConditionalOnClass(value={HealthIndicator.class})
public class AzureStorageActuatorAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public BlobStorageHealthIndicator blobStorageHealthIndicator() {
        return new BlobStorageHealthIndicator(this.applicationContext);
    }

    @Bean
    public FileStorageHealthIndicator fileStorageHealthIndicator() {
        return new FileStorageHealthIndicator(this.applicationContext);
    }
}

