/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.storage.actuator;

import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.microsoft.azure.spring.cloud.autoconfigure.storage.actuator.AzureStorageActuatorConstants;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.ApplicationContext;

public class BlobStorageHealthIndicator
implements HealthIndicator {
    private BlobServiceAsyncClient internalClient;

    public BlobStorageHealthIndicator(ApplicationContext applicationContext) {
        BlobServiceClientBuilder blobStorageClientBuilder = (BlobServiceClientBuilder)applicationContext.getBean(BlobServiceClientBuilder.class);
        this.internalClient = blobStorageClientBuilder.buildAsyncClient();
    }

    public Health health() {
        Health.Builder healthBuilder;
        block6: {
            healthBuilder = new Health.Builder();
            try {
                if (this.internalClient == null) {
                    healthBuilder.status(AzureStorageActuatorConstants.NOT_CONFIGURED_STATUS);
                    break block6;
                }
                healthBuilder.withDetail("URL", (Object)this.internalClient.getAccountUrl());
                StorageAccountInfo info = null;
                try {
                    info = (StorageAccountInfo)this.internalClient.getAccountInfo().block(AzureStorageActuatorConstants.POLL_TIMEOUT);
                    if (info != null) {
                        healthBuilder.up();
                    }
                }
                catch (Exception e) {
                    healthBuilder.down((Throwable)e);
                }
            }
            catch (Exception e) {
                healthBuilder.status("Could not complete health check.").down((Throwable)e);
            }
        }
        return healthBuilder.build();
    }
}

