/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.storage.actuator;

import com.azure.core.http.rest.Response;
import com.azure.storage.file.share.ShareServiceAsyncClient;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import com.microsoft.azure.spring.cloud.autoconfigure.storage.actuator.AzureStorageActuatorConstants;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.context.ApplicationContext;

public class FileStorageHealthIndicator
implements HealthIndicator {
    private ShareServiceAsyncClient internalClient;

    public FileStorageHealthIndicator(ApplicationContext applicationContext) {
        ShareServiceClientBuilder shareStorageClientBuilder = (ShareServiceClientBuilder)applicationContext.getBean(ShareServiceClientBuilder.class);
        this.internalClient = shareStorageClientBuilder.buildAsyncClient();
    }

    public Health health() {
        Health.Builder healthBuilder = new Health.Builder();
        try {
            healthBuilder.withDetail("URL", (Object)this.internalClient.getFileServiceUrl());
            Response infoResponse = null;
            try {
                infoResponse = (Response)this.internalClient.getPropertiesWithResponse().block(AzureStorageActuatorConstants.POLL_TIMEOUT);
                if (infoResponse != null) {
                    healthBuilder.up();
                }
            }
            catch (Exception e) {
                healthBuilder.down((Throwable)e);
            }
        }
        catch (Exception e) {
            healthBuilder.status("Could not complete health check.").down((Throwable)e);
        }
        return healthBuilder.build();
    }
}

