/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.storage;

import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import com.microsoft.azure.spring.cloud.storage.AzureStorageUtils;
import com.microsoft.azure.spring.cloud.storage.BlobStorageResource;
import com.microsoft.azure.spring.cloud.storage.FileStorageResource;
import com.microsoft.azure.spring.cloud.storage.StorageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class AzureStorageProtocolResolver
implements ProtocolResolver,
BeanFactoryPostProcessor,
ResourceLoaderAware {
    private static final Logger LOG = LoggerFactory.getLogger(AzureStorageProtocolResolver.class);
    private ConfigurableListableBeanFactory beanFactory;
    private BlobServiceClientBuilder blobServiceClientBuilder;
    private ShareServiceClientBuilder shareServiceClientBuilder;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        if (resourceLoader instanceof DefaultResourceLoader) {
            ((DefaultResourceLoader)resourceLoader).addProtocolResolver((ProtocolResolver)this);
        } else {
            LOG.warn("Custom Protocol using azure-blob:// or azure-file:// prefix will not be enabled.");
        }
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (AzureStorageUtils.isAzureStorageResource(location, StorageType.BLOB)) {
            return new BlobStorageResource(this.getBlobServiceClientBuilder().buildClient(), location, true);
        }
        if (AzureStorageUtils.isAzureStorageResource(location, StorageType.FILE)) {
            return new FileStorageResource(this.getShareServiceClientBuilder().buildClient(), location, true);
        }
        return null;
    }

    private BlobServiceClientBuilder getBlobServiceClientBuilder() {
        if (this.blobServiceClientBuilder == null) {
            this.blobServiceClientBuilder = (BlobServiceClientBuilder)this.beanFactory.getBean(BlobServiceClientBuilder.class);
        }
        return this.blobServiceClientBuilder;
    }

    private ShareServiceClientBuilder getShareServiceClientBuilder() {
        if (this.shareServiceClientBuilder == null) {
            this.shareServiceClientBuilder = (ShareServiceClientBuilder)this.beanFactory.getBean(ShareServiceClientBuilder.class);
        }
        return this.shareServiceClientBuilder;
    }
}

