/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.storage;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.azure.storage.file.share.models.ShareFileItem;
import com.azure.storage.file.share.models.ShareItem;
import com.microsoft.azure.spring.cloud.storage.AzureStorageResource;
import com.microsoft.azure.spring.cloud.storage.AzureStorageUtils;
import com.microsoft.azure.spring.cloud.storage.BlobStorageResource;
import com.microsoft.azure.spring.cloud.storage.FileStorageResource;
import com.microsoft.azure.spring.cloud.storage.StorageType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;

public class AzureStorageResourcePatternResolver
implements ResourcePatternResolver {
    private final AntPathMatcher matcher = new AntPathMatcher();
    private Optional<BlobServiceClient> blobServiceClient;
    private Optional<ShareServiceClient> shareServiceClient;

    public AzureStorageResourcePatternResolver(BlobServiceClient blobServiceClient) {
        this(blobServiceClient, null);
    }

    public AzureStorageResourcePatternResolver(ShareServiceClient shareServiceClient) {
        this(null, shareServiceClient);
    }

    public AzureStorageResourcePatternResolver(BlobServiceClient blobServiceClient, ShareServiceClient shareServiceClient) {
        this.blobServiceClient = Optional.ofNullable(blobServiceClient);
        this.shareServiceClient = Optional.ofNullable(shareServiceClient);
    }

    public Resource[] getResources(String pattern) throws IOException {
        Resource[] resources = null;
        if (AzureStorageUtils.isAzureStorageResource(pattern, StorageType.BLOB)) {
            resources = this.getBlobResources(pattern);
        } else if (AzureStorageUtils.isAzureStorageResource(pattern, StorageType.FILE)) {
            resources = this.getShareResources(pattern);
        }
        if (null == resources) {
            throw new IOException("Resources not found at " + pattern);
        }
        return resources;
    }

    public Resource getResource(String location) {
        AzureStorageResource resource = null;
        if (AzureStorageUtils.isAzureStorageResource(location, StorageType.BLOB) && this.blobServiceClient.isPresent()) {
            resource = new BlobStorageResource(this.blobServiceClient.get(), location, true);
        } else if (AzureStorageUtils.isAzureStorageResource(location, StorageType.FILE) && this.shareServiceClient.isPresent()) {
            resource = new FileStorageResource(this.shareServiceClient.get(), location, true);
        }
        if (null == resource) {
            throw new IllegalArgumentException("Resource not found at " + location);
        }
        return resource;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    private Resource[] getBlobResources(String pattern) {
        ArrayList resources = new ArrayList();
        this.blobServiceClient.ifPresent(client -> {
            for (BlobContainerItem containerItem : client.listBlobContainers()) {
                String containerName = containerItem.getName();
                BlobContainerClient blobContainerClient = client.getBlobContainerClient(containerItem.getName());
                for (BlobItem blobItem : blobContainerClient.listBlobs()) {
                    String blobName = blobItem.getName();
                    String location = "azure-blob://" + containerName + "/" + blobName;
                    if (!this.matcher.match(pattern, location)) continue;
                    resources.add(new BlobStorageResource((BlobServiceClient)client, location));
                }
            }
        });
        return resources.toArray(new Resource[0]);
    }

    private Resource[] getShareResources(String pattern) {
        ArrayList resources = new ArrayList();
        this.shareServiceClient.ifPresent(client -> {
            for (ShareItem shareItem : client.listShares()) {
                String shareName = shareItem.getName();
                ShareClient shareClient = client.getShareClient(shareItem.getName());
                for (ShareFileItem fileItem : shareClient.getRootDirectoryClient().listFilesAndDirectories()) {
                    String location;
                    String filename = fileItem.getName();
                    if (fileItem.isDirectory() || !this.matcher.match(pattern, location = "azure-file://" + shareName + "/" + filename)) continue;
                    resources.add(new FileStorageResource((ShareServiceClient)client, location));
                }
            }
        });
        return resources.toArray(new Resource[0]);
    }
}

