/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.spring.data.cosmosdb.common.MacAddress;
import com.microsoft.azure.spring.data.cosmosdb.common.PropertyLoader;
import com.microsoft.azure.spring.data.cosmosdb.common.TelemetryEventTracker;
import com.microsoft.azure.spring.data.cosmosdb.config.DocumentDBConfig;
import lombok.NonNull;
import org.springframework.util.Assert;

public class DocumentDbFactory {
    private final DocumentDBConfig config;
    private final TelemetryEventTracker telemetryEventTracker;
    private static final boolean IS_TELEMETRY_ALLOWED = PropertyLoader.isApplicationTelemetryAllowed();
    private static final String USER_AGENT_SUFFIX = "spring-data/" + PropertyLoader.getProjectVersion();

    private String getUserAgentSuffix() {
        String suffix = ";" + USER_AGENT_SUFFIX;
        if (IS_TELEMETRY_ALLOWED) {
            suffix = suffix + ";" + MacAddress.getHashMac();
        }
        return suffix;
    }

    public DocumentDbFactory(@NonNull DocumentDBConfig config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        this.validateConfig(config);
        this.config = config;
        this.telemetryEventTracker = new TelemetryEventTracker(IS_TELEMETRY_ALLOWED);
        this.telemetryEventTracker.trackEvent(this.getClass().getSimpleName());
    }

    public DocumentClient getDocumentClient() {
        ConnectionPolicy policy = this.config.getConnectionPolicy();
        policy.setUserAgentSuffix(this.getUserAgentSuffix());
        return new DocumentClient(this.config.getUri(), this.config.getKey(), policy, this.config.getConsistencyLevel());
    }

    private void validateConfig(@NonNull DocumentDBConfig config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        Assert.hasText((String)config.getUri(), (String)"cosmosdb host url should have text!");
        Assert.hasText((String)config.getKey(), (String)"cosmosdb host key should have text!");
        Assert.hasText((String)config.getDatabase(), (String)"cosmosdb database should have text!");
        Assert.notNull((Object)config.getConnectionPolicy(), (String)"cosmosdb connection policy should not be null!");
    }
}

