/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.common;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.azure.spring.data.cosmosdb.common.MacAddress;
import com.microsoft.azure.spring.data.cosmosdb.common.PropertyLoader;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class TelemetryEventTracker {
    private static final String PROPERTY_INSTALLATION_ID = "installationId";
    private static final String PROPERTY_VERSION = "version";
    private static final String PROPERTY_SERVICE_NAME = "serviceName";
    private static final String PROJECT_INFO = "spring-data-cosmosdb/" + PropertyLoader.getProjectVersion();
    private final boolean isTelemetryAllowed;
    private final TelemetryClient client = new TelemetryClient();

    public TelemetryEventTracker(boolean isTelemetryAllowed) {
        this.isTelemetryAllowed = isTelemetryAllowed;
    }

    public void trackEvent(@NonNull String eventName) {
        if (eventName == null) {
            throw new NullPointerException("eventName");
        }
        if (this.isTelemetryAllowed()) {
            this.getClient().trackEvent(eventName, this.getDefaultProperties(), null);
            this.getClient().flush();
        }
    }

    private Map<String, String> getDefaultProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(PROPERTY_VERSION, PROJECT_INFO);
        properties.put(PROPERTY_SERVICE_NAME, "cosmosdb");
        properties.put(PROPERTY_INSTALLATION_ID, MacAddress.getHashMac());
        return properties;
    }

    private boolean isTelemetryAllowed() {
        return this.isTelemetryAllowed;
    }

    private TelemetryClient getClient() {
        return this.client;
    }
}

