/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.config;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.ConsistencyLevel;
import java.beans.ConstructorProperties;

public class DocumentDBConfig {
    private String uri;
    private String key;
    private String database;
    private ConnectionPolicy connectionPolicy;
    private ConsistencyLevel consistencyLevel;
    private boolean allowTelemetry;

    public static DocumentDBConfigBuilder builder(String uri, String key, String database) {
        return DocumentDBConfig.defaultBuilder().uri(uri).key(key).database(database).connectionPolicy(ConnectionPolicy.GetDefault()).consistencyLevel(ConsistencyLevel.Session);
    }

    @ConstructorProperties(value={"uri", "key", "database", "connectionPolicy", "consistencyLevel", "allowTelemetry"})
    DocumentDBConfig(String uri, String key, String database, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, boolean allowTelemetry) {
        this.uri = uri;
        this.key = key;
        this.database = database;
        this.connectionPolicy = connectionPolicy;
        this.consistencyLevel = consistencyLevel;
        this.allowTelemetry = allowTelemetry;
    }

    public static DocumentDBConfigBuilder defaultBuilder() {
        return new DocumentDBConfigBuilder();
    }

    public String getUri() {
        return this.uri;
    }

    public String getKey() {
        return this.key;
    }

    public String getDatabase() {
        return this.database;
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public static class DocumentDBConfigBuilder {
        private String uri;
        private String key;
        private String database;
        private ConnectionPolicy connectionPolicy;
        private ConsistencyLevel consistencyLevel;
        private boolean allowTelemetry;

        DocumentDBConfigBuilder() {
        }

        public DocumentDBConfigBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public DocumentDBConfigBuilder key(String key) {
            this.key = key;
            return this;
        }

        public DocumentDBConfigBuilder database(String database) {
            this.database = database;
            return this;
        }

        public DocumentDBConfigBuilder connectionPolicy(ConnectionPolicy connectionPolicy) {
            this.connectionPolicy = connectionPolicy;
            return this;
        }

        public DocumentDBConfigBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public DocumentDBConfigBuilder allowTelemetry(boolean allowTelemetry) {
            this.allowTelemetry = allowTelemetry;
            return this;
        }

        public DocumentDBConfig build() {
            return new DocumentDBConfig(this.uri, this.key, this.database, this.connectionPolicy, this.consistencyLevel, this.allowTelemetry);
        }

        public String toString() {
            return "DocumentDBConfig.DocumentDBConfigBuilder(uri=" + this.uri + ", key=" + this.key + ", database=" + this.database + ", connectionPolicy=" + this.connectionPolicy + ", consistencyLevel=" + this.consistencyLevel + ", allowTelemetry=" + this.allowTelemetry + ")";
        }
    }
}

