/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core;

import com.microsoft.azure.documentdb.DataType;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.Index;
import com.microsoft.azure.documentdb.IndexingPolicy;
import com.microsoft.azure.documentdb.RangeIndex;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.springframework.lang.NonNull;

class QueryValidator {
    QueryValidator() {
    }

    static boolean isCollectionSupportSortByString(@NonNull DocumentCollection collection) {
        IndexingPolicy policy = collection.getIndexingPolicy();
        ArrayList indices = new ArrayList();
        policy.getIncludedPaths().forEach(p -> indices.addAll(p.getIndexes()));
        return indices.stream().anyMatch(QueryValidator.isIndexingSupportSortByString());
    }

    static boolean isCollectionSupportStartsWith(@NonNull DocumentCollection collection) {
        IndexingPolicy policy = collection.getIndexingPolicy();
        ArrayList indices = new ArrayList();
        policy.getIncludedPaths().forEach(p -> indices.addAll(p.getIndexes()));
        return indices.stream().anyMatch(QueryValidator.isIndexingSupportStartsWith());
    }

    private static Predicate<Index> isIndexingSupportSortByString() {
        return index -> {
            if (index instanceof RangeIndex) {
                RangeIndex rangeIndex = (RangeIndex)index;
                return rangeIndex.getDataType() == DataType.String && rangeIndex.getPrecision() == -1;
            }
            return false;
        };
    }

    private static Predicate<Index> isIndexingSupportStartsWith() {
        return index -> {
            if (index instanceof RangeIndex) {
                RangeIndex rangeIndex = (RangeIndex)index;
                return rangeIndex.getDataType() == DataType.String;
            }
            return false;
        };
    }
}

