/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core.convert;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.ObjectMapperFactory;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.DocumentDbPersistentEntity;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.DocumentDbPersistentProperty;
import com.microsoft.azure.spring.data.cosmosdb.exception.DocumentDBAccessException;
import java.io.IOException;
import java.util.Date;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.util.Assert;

public class MappingDocumentDbConverter
implements EntityConverter<DocumentDbPersistentEntity<?>, DocumentDbPersistentProperty, Object, Document>,
ApplicationContextAware {
    protected final MappingContext<? extends DocumentDbPersistentEntity<?>, DocumentDbPersistentProperty> mappingContext;
    protected GenericConversionService conversionService;
    private ApplicationContext applicationContext;
    private ObjectMapper objectMapper;

    public MappingDocumentDbConverter(MappingContext<? extends DocumentDbPersistentEntity<?>, DocumentDbPersistentProperty> mappingContext, @Qualifier(value="cosmosdbObjectMapper") ObjectMapper objectMapper) {
        this.mappingContext = mappingContext;
        this.conversionService = new GenericConversionService();
        this.objectMapper = objectMapper == null ? ObjectMapperFactory.getObjectMapper() : objectMapper;
    }

    public <R> R read(Class<R> type, Document sourceDocument) {
        if (sourceDocument == null) {
            return null;
        }
        DocumentDbPersistentEntity entity = (DocumentDbPersistentEntity)this.mappingContext.getPersistentEntity(type);
        Assert.notNull((Object)entity, (String)"Entity is null.");
        return this.readInternal(entity, type, sourceDocument);
    }

    protected <R> R readInternal(DocumentDbPersistentEntity<?> entity, Class<R> type, Document sourceDocument) {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            DocumentDbPersistentProperty idProperty = (DocumentDbPersistentProperty)entity.getIdProperty();
            String idValue = sourceDocument.getId();
            JSONObject jsonObject = new JSONObject(sourceDocument.toJson());
            if (idProperty != null) {
                jsonObject.remove("id");
                jsonObject.put(idProperty.getName(), (Object)idValue);
            }
            return (R)this.objectMapper.readValue(jsonObject.toString(), type);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read the source document " + sourceDocument.toJson() + "  to target type " + type, e);
        }
    }

    @Deprecated
    public void write(Object sourceEntity, Document document) {
        throw new UnsupportedOperationException("The feature is not implemented yet");
    }

    public Document writeDoc(Object sourceEntity) {
        Document document;
        if (sourceEntity == null) {
            return null;
        }
        DocumentDbPersistentEntity persistentEntity = (DocumentDbPersistentEntity)this.mappingContext.getPersistentEntity(sourceEntity.getClass());
        if (persistentEntity == null) {
            throw new MappingException("no mapping metadata for entity type: " + sourceEntity.getClass().getName());
        }
        ConvertingPropertyAccessor accessor = this.getPropertyAccessor(sourceEntity);
        DocumentDbPersistentProperty idProperty = (DocumentDbPersistentProperty)persistentEntity.getIdProperty();
        try {
            document = new Document(this.objectMapper.writeValueAsString(sourceEntity));
        }
        catch (JsonProcessingException e) {
            throw new DocumentDBAccessException("Failed to map document value.", e);
        }
        if (idProperty != null) {
            Object value = accessor.getProperty((PersistentProperty)idProperty);
            String id = value == null ? null : value.toString();
            document.setId(id);
        }
        return document;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public MappingContext<? extends DocumentDbPersistentEntity<?>, DocumentDbPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    private ConvertingPropertyAccessor getPropertyAccessor(Object entity) {
        DocumentDbPersistentEntity entityInformation = (DocumentDbPersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        Assert.notNull((Object)entityInformation, (String)"EntityInformation should not be null.");
        PersistentPropertyAccessor accessor = entityInformation.getPropertyAccessor(entity);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)this.conversionService);
    }

    public static Object toDocumentDBValue(Object fromPropertyValue) {
        if (fromPropertyValue == null) {
            return null;
        }
        if (fromPropertyValue instanceof Date) {
            fromPropertyValue = ((Date)fromPropertyValue).getTime();
        } else if (fromPropertyValue instanceof Enum) {
            fromPropertyValue = fromPropertyValue.toString();
        }
        return fromPropertyValue;
    }
}

