/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core.query;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.reflect.FieldUtils;
import com.microsoft.azure.spring.data.cosmosdb.core.query.Criteria;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import com.microsoft.azure.spring.data.cosmosdb.exception.IllegalQueryException;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.DocumentDbEntityInformation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class DocumentQuery {
    private final Criteria criteria;
    private Sort sort = Sort.unsorted();
    private Pageable pageable = Pageable.unpaged();

    public DocumentQuery(@NonNull Criteria criteria) {
        this.criteria = criteria;
    }

    public DocumentQuery with(@NonNull Sort sort) {
        if (sort.isSorted()) {
            this.sort = sort.and(this.sort);
        }
        return this;
    }

    public DocumentQuery with(@NonNull Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"pageable should not be null");
        this.pageable = pageable;
        return this;
    }

    private boolean isCrossPartitionQuery(@NonNull String keyName) {
        Assert.hasText((String)keyName, (String)"PartitionKey should have text.");
        Optional<Criteria> criteria = this.getSubjectCriteria(this.criteria, keyName);
        return criteria.map(criteria1 -> criteria1.getType() != CriteriaType.IS_EQUAL).orElse(true);
    }

    private boolean hasKeywordOr() {
        return this.criteria.getType() == CriteriaType.OR;
    }

    public boolean isCrossPartitionQuery(@NonNull List<String> partitionKeys) {
        if (partitionKeys.isEmpty()) {
            return true;
        }
        for (String keyName : partitionKeys) {
            if (!this.isCrossPartitionQuery(keyName)) continue;
            return true;
        }
        return this.hasKeywordOr();
    }

    public Optional<Criteria> getCriteriaByType(@NonNull CriteriaType criteriaType) {
        return this.getCriteriaByType(criteriaType, this.criteria);
    }

    private Optional<Criteria> getCriteriaByType(@NonNull CriteriaType criteriaType, @NonNull Criteria criteria) {
        if (criteria.getType().equals((Object)criteriaType)) {
            return Optional.of(criteria);
        }
        for (Criteria subCriteria : criteria.getSubCriteria()) {
            if (!this.getCriteriaByType(criteriaType, subCriteria).isPresent()) continue;
            return Optional.of(subCriteria);
        }
        return Optional.empty();
    }

    private Optional<Criteria> getSubjectCriteria(@NonNull Criteria criteria, @NonNull String keyName) {
        if (keyName.equals(criteria.getSubject())) {
            return Optional.of(criteria);
        }
        List<Criteria> subCriteriaList = criteria.getSubCriteria();
        for (Criteria c : subCriteriaList) {
            Optional<Criteria> subjectCriteria = this.getSubjectCriteria(c, keyName);
            if (!subjectCriteria.isPresent()) continue;
            return subjectCriteria;
        }
        return Optional.empty();
    }

    public void validateSort(@NonNull Class<?> domainClass, boolean isCollectionSupportSortByString) {
        if (this.sort.isUnsorted()) {
            return;
        }
        if (this.sort.stream().count() != 1L) {
            throw new IllegalQueryException("only one order of Sort is supported");
        }
        Sort.Order order = (Sort.Order)this.sort.iterator().next();
        String property = order.getProperty();
        String idFieldName = new DocumentDbEntityInformation(domainClass).getIdField().getName();
        Field[] fields = FieldUtils.getAllFields(domainClass);
        Optional<Field> field = Arrays.stream(fields).filter(f -> f.getName().equals(property)).findFirst();
        if (order.isIgnoreCase()) {
            throw new IllegalQueryException("sort within case insensitive is not supported");
        }
        if (property.equals("id") || property.equals(idFieldName)) {
            throw new IllegalQueryException("sort by @Id field is not supported");
        }
        if (!field.isPresent()) {
            throw new IllegalQueryException("order name must be consistence with domainClass");
        }
        if (field.get().getType() == String.class && !isCollectionSupportSortByString) {
            throw new IllegalQueryException("order by String must enable indexing with Range and max Precision.");
        }
    }

    public void validateStartsWith(boolean isCollectionSupportStartsWith) {
        if (!this.getCriteriaByType(CriteriaType.STARTS_WITH).isPresent()) {
            return;
        }
        if (!isCollectionSupportStartsWith) {
            throw new IllegalQueryException("STARTSWITH keyword must enable indexing with Range and max Precision.");
        }
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Pageable getPageable() {
        return this.pageable;
    }
}

